/*
 * Decompiled with CFR 0.152.
 */
package org.microbean.proxy;

import java.lang.reflect.Constructor;
import java.lang.reflect.Executable;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.GenericDeclaration;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.lang.reflect.WildcardType;
import java.lang.runtime.SwitchBootstraps;
import java.util.List;
import java.util.function.Supplier;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Parameterizable;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import org.microbean.construct.Domain;
import org.microbean.proxy.AbstractProxier;
import org.microbean.proxy.Proxy;
import org.microbean.proxy.ProxySpecification;

public abstract class AbstractReflectiveProxier<PS extends ProxySpecification>
extends AbstractProxier<PS> {
    private static final TypeMirror[] EMPTY_TYPE_MIRROR_ARRAY = new TypeMirror[0];

    protected AbstractReflectiveProxier(Domain domain) {
        super(domain);
    }

    protected final boolean equalsMethod(Method m) {
        return m.getDeclaringClass() == Object.class && m.getReturnType() == Boolean.TYPE && m.getParameterCount() == 1 && m.getParameterTypes()[0] == Object.class && m.getName().equals("equals");
    }

    protected final ExecutableElement executableElement(Executable e) {
        Domain domain = this.domain();
        Executable executable = e;
        int n = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Constructor.class, Method.class}, (Object)executable, n)) {
            case -1 -> throw new NullPointerException("e");
            case 0 -> {
                Constructor c = (Constructor)executable;
                yield domain.executableElement(domain.typeElement((CharSequence)c.getDeclaringClass().getCanonicalName()), (TypeMirror)domain.noType(TypeKind.VOID), (CharSequence)"<init>", this.types(c.getParameterTypes()));
            }
            case 1 -> {
                Method m = (Method)executable;
                yield domain.executableElement(domain.typeElement((CharSequence)m.getDeclaringClass().getCanonicalName()), this.type(m.getReturnType()), (CharSequence)m.getName(), this.types(m.getParameterTypes()));
            }
            default -> throw new IllegalArgumentException("e: " + String.valueOf(e));
        };
    }

    protected final boolean hashCodeMethod(Method m) {
        return m.getDeclaringClass() == Object.class && m.getReturnType() == Integer.TYPE && m.getParameterCount() == 0 && m.getName().equals("hashCode");
    }

    protected final Parameterizable parameterizable(GenericDeclaration gd) {
        Domain domain = this.domain();
        GenericDeclaration genericDeclaration = gd;
        int n = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Class.class, Executable.class}, (Object)genericDeclaration, n)) {
            case -1 -> throw new NullPointerException("gd");
            case 0 -> {
                Class c = (Class)genericDeclaration;
                yield domain.typeElement((CharSequence)c.getCanonicalName());
            }
            case 1 -> {
                Executable e = (Executable)genericDeclaration;
                yield this.executableElement(e);
            }
            default -> throw new IllegalArgumentException("gd: " + String.valueOf(gd));
        };
    }

    @Override
    public final <R> Proxy<R> proxy(PS ps, Supplier<? extends R> instanceSupplier) {
        Domain domain = this.domain();
        if (!domain.javaLangObject((TypeMirror)((ProxySpecification)ps).superclass())) {
            throw new IllegalArgumentException("ps: " + String.valueOf(ps));
        }
        List<TypeMirror> interfaceTypeMirrors = ((ProxySpecification)ps).interfaces();
        int size = interfaceTypeMirrors.size();
        Class[] interfaces = new Class[size];
        ClassLoader classLoader = this.classLoader();
        try {
            for (int i = 0; i < size; ++i) {
                TypeElement e = (TypeElement)((DeclaredType)interfaceTypeMirrors.get(i)).asElement();
                String binaryName = domain.toString((CharSequence)domain.binaryName(e));
                interfaces[i] = Class.forName(binaryName, false, classLoader);
            }
        }
        catch (ClassNotFoundException cnfe) {
            throw new IllegalArgumentException("ps: " + String.valueOf(ps), cnfe);
        }
        return this.proxy(ps, interfaces, instanceSupplier);
    }

    protected abstract <R> Proxy<R> proxy(PS var1, Class<?>[] var2, Supplier<? extends R> var3);

    protected final TypeMirror type(Type t) {
        TypeMirror typeMirror;
        Domain domain = this.domain();
        Type type = t;
        int n = 0;
        block21: while (true) {
            switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Class.class, Class.class, Class.class, Class.class, Class.class, Class.class, Class.class, Class.class, Class.class, Class.class, Class.class, Class.class, GenericArrayType.class, ParameterizedType.class, ParameterizedType.class, TypeVariable.class, WildcardType.class, WildcardType.class}, (Object)type, n)) {
                case -1: {
                    throw new NullPointerException("t");
                }
                case 0: {
                    Class c = (Class)type;
                    if (t != Boolean.TYPE) {
                        n = 1;
                        continue block21;
                    }
                    typeMirror = domain.primitiveType(TypeKind.BOOLEAN);
                    break block21;
                }
                case 1: {
                    Class c = (Class)type;
                    if (t != Byte.TYPE) {
                        n = 2;
                        continue block21;
                    }
                    typeMirror = domain.primitiveType(TypeKind.BYTE);
                    break block21;
                }
                case 2: {
                    Class c = (Class)type;
                    if (t != Character.TYPE) {
                        n = 3;
                        continue block21;
                    }
                    typeMirror = domain.primitiveType(TypeKind.CHAR);
                    break block21;
                }
                case 3: {
                    Class c = (Class)type;
                    if (t != Double.TYPE) {
                        n = 4;
                        continue block21;
                    }
                    typeMirror = domain.primitiveType(TypeKind.DOUBLE);
                    break block21;
                }
                case 4: {
                    Class c = (Class)type;
                    if (t != Float.TYPE) {
                        n = 5;
                        continue block21;
                    }
                    typeMirror = domain.primitiveType(TypeKind.FLOAT);
                    break block21;
                }
                case 5: {
                    Class c = (Class)type;
                    if (t != Integer.TYPE) {
                        n = 6;
                        continue block21;
                    }
                    typeMirror = domain.primitiveType(TypeKind.INT);
                    break block21;
                }
                case 6: {
                    Class c = (Class)type;
                    if (t != Long.TYPE) {
                        n = 7;
                        continue block21;
                    }
                    typeMirror = domain.primitiveType(TypeKind.LONG);
                    break block21;
                }
                case 7: {
                    Class c = (Class)type;
                    if (t != Short.TYPE) {
                        n = 8;
                        continue block21;
                    }
                    typeMirror = domain.primitiveType(TypeKind.SHORT);
                    break block21;
                }
                case 8: {
                    Class c = (Class)type;
                    if (t != Void.TYPE) {
                        n = 9;
                        continue block21;
                    }
                    typeMirror = domain.noType(TypeKind.VOID);
                    break block21;
                }
                case 9: {
                    Class c = (Class)type;
                    if (t != Object.class) {
                        n = 10;
                        continue block21;
                    }
                    typeMirror = domain.javaLangObject().asType();
                    break block21;
                }
                case 10: {
                    Class c = (Class)type;
                    if (!c.isArray()) {
                        n = 11;
                        continue block21;
                    }
                    typeMirror = domain.arrayTypeOf(this.type(c.getComponentType()));
                    break block21;
                }
                case 11: {
                    Class c = (Class)type;
                    typeMirror = domain.declaredType((CharSequence)c.getCanonicalName());
                    break block21;
                }
                case 12: {
                    GenericArrayType g = (GenericArrayType)type;
                    typeMirror = domain.arrayTypeOf(this.type(g.getGenericComponentType()));
                    break block21;
                }
                case 13: {
                    ParameterizedType pt = (ParameterizedType)type;
                    if (pt.getOwnerType() != null) {
                        n = 14;
                        continue block21;
                    }
                    typeMirror = domain.declaredType(domain.typeElement((CharSequence)((Class)pt.getRawType()).getCanonicalName()), this.types(pt.getActualTypeArguments()));
                    break block21;
                }
                case 14: {
                    ParameterizedType pt = (ParameterizedType)type;
                    typeMirror = domain.declaredType((DeclaredType)this.type(pt.getOwnerType()), domain.typeElement((CharSequence)((Class)pt.getRawType()).getCanonicalName()), this.types(pt.getActualTypeArguments()));
                    break block21;
                }
                case 15: {
                    TypeVariable tv = (TypeVariable)type;
                    typeMirror = domain.typeVariable(this.parameterizable((GenericDeclaration)tv.getGenericDeclaration()), (CharSequence)tv.getName());
                    break block21;
                }
                case 16: {
                    WildcardType w = (WildcardType)type;
                    if (w.getLowerBounds().length > 0) {
                        n = 17;
                        continue block21;
                    }
                    typeMirror = domain.wildcardType(this.type(w.getUpperBounds()[0]), null);
                    break block21;
                }
                case 17: {
                    WildcardType w = (WildcardType)type;
                    typeMirror = domain.wildcardType(null, this.type(w.getLowerBounds()[0]));
                    break block21;
                }
                default: {
                    throw new IllegalArgumentException("t: " + String.valueOf(t));
                }
            }
            break;
        }
        return typeMirror;
    }

    protected final TypeMirror[] types(Type[] ts) {
        if (ts.length <= 0) {
            return EMPTY_TYPE_MIRROR_ARRAY;
        }
        if (ts.length == 1) {
            return new TypeMirror[]{this.type(ts[0])};
        }
        TypeMirror[] rv = new TypeMirror[ts.length];
        for (int i = 0; i < ts.length; ++i) {
            rv[i] = this.type(ts[i]);
        }
        return rv;
    }
}

