/*
 * Decompiled with CFR 0.152.
 */
package org.microbean.microprofile.config.cdi;

import java.lang.annotation.Annotation;
import java.lang.reflect.Member;
import java.lang.reflect.Type;
import java.util.Collections;
import java.util.HashSet;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import javax.enterprise.context.Dependent;
import javax.enterprise.context.spi.CreationalContext;
import javax.enterprise.inject.spi.Annotated;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.BeanManager;
import javax.enterprise.inject.spi.CDI;
import javax.enterprise.inject.spi.InjectionPoint;
import javax.enterprise.inject.spi.PassivationCapable;
import org.eclipse.microprofile.config.Config;
import org.eclipse.microprofile.config.inject.ConfigProperty;
import org.microbean.microprofile.config.TypeConverter;
import org.microbean.microprofile.config.cdi.AnyLiteral;
import org.microbean.microprofile.config.cdi.ConfigExtension;
import org.microbean.microprofile.config.cdi.ConfigPropertyLiteral;
import org.microbean.microprofile.config.cdi.DefaultLiteral;

final class ConfigPropertyBean<T>
implements Bean<T>,
PassivationCapable {
    private static final Set<InjectionPoint> emptyInjectionPointSet = Collections.emptySet();
    private static final Set<Class<? extends Annotation>> emptyStereotypesSet = Collections.emptySet();
    private static final String[] emptyStringArray = new String[0];
    private final String id;
    private final Set<Type> types;
    private final Set<Annotation> qualifiers;
    private final Annotation[] configQualifiers;

    ConfigPropertyBean(Type type, Set<? extends Annotation> qualifiers) {
        this(type == null ? null : Collections.singleton(type), qualifiers);
    }

    ConfigPropertyBean(Set<? extends Type> types, Set<? extends Annotation> qualifiers) {
        this.types = types == null || types.isEmpty() ? Collections.emptySet() : Collections.unmodifiableSet(new HashSet<Type>(types));
        HashSet<Object> newQualifiers = new HashSet<Object>();
        newQualifiers.add(AnyLiteral.INSTANCE);
        if (qualifiers == null || qualifiers.isEmpty()) {
            newQualifiers.add(ConfigPropertyLiteral.INSTANCE);
            newQualifiers.add(DefaultLiteral.INSTANCE);
            this.configQualifiers = null;
        } else {
            HashSet<? extends Annotation> configQualifiers = new HashSet<Annotation>(qualifiers);
            newQualifiers.addAll(qualifiers);
            boolean found = false;
            for (Annotation annotation : qualifiers) {
                if (!(annotation instanceof ConfigProperty)) continue;
                found = true;
                configQualifiers.removeIf(q -> q instanceof ConfigProperty);
                break;
            }
            if (!found) {
                newQualifiers.add(ConfigPropertyLiteral.INSTANCE);
            }
            this.configQualifiers = configQualifiers.toArray(new Annotation[configQualifiers.size()]);
        }
        this.qualifiers = Collections.unmodifiableSet(newQualifiers);
        this.id = this.getClass().getName() + ";t:" + this.getTypes() + ";q:" + this.getQualifiers();
    }

    public final T create(CreationalContext<T> context) {
        TypeConverter typeConverter;
        Set beans;
        BeanManager beanManager = CDI.current().getBeanManager();
        assert (beanManager != null);
        InjectionPoint currentInjectionPoint = (InjectionPoint)beanManager.getInjectableReference((InjectionPoint)new CurrentInjectionPoint((Type)((Object)InjectionPoint.class)), context);
        assert (currentInjectionPoint != null);
        Set configBeans = this.configQualifiers == null ? beanManager.getBeans(Config.class, new Annotation[0]) : ((beans = beanManager.getBeans(Config.class, this.configQualifiers)) == null || beans.isEmpty() ? beanManager.getBeans(Config.class, new Annotation[0]) : beans);
        assert (configBeans != null);
        Config config = (Config)beanManager.getReference(beanManager.resolve(configBeans), Config.class, context);
        assert (config != null);
        String value = ConfigPropertyBean.getValue(config, currentInjectionPoint);
        if (config instanceof TypeConverter) {
            typeConverter = (TypeConverter)config;
        } else {
            Set typeConverterBeans = this.configQualifiers == null ? beanManager.getBeans(TypeConverter.class, new Annotation[0]) : beanManager.getBeans(TypeConverter.class, this.configQualifiers);
            typeConverter = (TypeConverter)beanManager.getReference(beanManager.resolve(typeConverterBeans), TypeConverter.class, context);
        }
        Object returnValue = typeConverter.convert(value == null ? ConfigPropertyBean.getDefaultValue(currentInjectionPoint) : value, currentInjectionPoint.getType());
        return returnValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void destroy(T configurationValue, CreationalContext<T> creationalContext) {
        block8: {
            try {
                if (!(configurationValue instanceof AutoCloseable)) break block8;
                try {
                    ((AutoCloseable)configurationValue).close();
                }
                catch (InterruptedException interruptedException) {
                    Thread.currentThread().interrupt();
                }
                catch (RuntimeException throwMe) {
                    throw throwMe;
                }
                catch (Exception exception) {
                    throw new RuntimeException(exception.getMessage(), exception);
                }
            }
            finally {
                if (creationalContext != null) {
                    creationalContext.release();
                }
            }
        }
    }

    public final Set<InjectionPoint> getInjectionPoints() {
        return emptyInjectionPointSet;
    }

    public final Class<?> getBeanClass() {
        return ConfigPropertyBean.class;
    }

    public final boolean isNullable() {
        return false;
    }

    public final Set<Type> getTypes() {
        return this.types;
    }

    public final Set<Annotation> getQualifiers() {
        return this.qualifiers;
    }

    public final Class<? extends Annotation> getScope() {
        return Dependent.class;
    }

    public final String getName() {
        return null;
    }

    public final Set<Class<? extends Annotation>> getStereotypes() {
        return emptyStereotypesSet;
    }

    public final boolean isAlternative() {
        return false;
    }

    public final String getId() {
        return this.id;
    }

    public String toString() {
        return this.getId();
    }

    private static final String getDefaultValue(InjectionPoint injectionPoint) {
        String returnValue;
        Objects.requireNonNull(injectionPoint);
        ConfigProperty configProperty = null;
        Set qualifiers = injectionPoint.getQualifiers();
        if (qualifiers != null) {
            for (Annotation qualifier : qualifiers) {
                if (qualifier == null || !ConfigProperty.class.equals(qualifier.annotationType())) continue;
                configProperty = (ConfigProperty)qualifier;
                break;
            }
        }
        if (configProperty == null) {
            returnValue = null;
        } else {
            String defaultValue = configProperty.defaultValue();
            assert (defaultValue != null);
            returnValue = defaultValue.equals("org.eclipse.microprofile.config.configproperty.unconfigureddvalue") ? null : defaultValue;
        }
        return returnValue;
    }

    private static final String getValue(Config config, InjectionPoint injectionPoint) {
        Optional optionalValue;
        Objects.requireNonNull(config);
        Objects.requireNonNull(injectionPoint);
        String returnValue = null;
        String name = ConfigExtension.getConfigPropertyName(injectionPoint);
        if (name != null && !name.isEmpty() && (optionalValue = config.getOptionalValue(name, String.class)).isPresent()) {
            returnValue = (String)optionalValue.get();
        }
        return returnValue;
    }

    private static final class CurrentInjectionPoint
    implements InjectionPoint {
        private final Type type;

        private CurrentInjectionPoint(Type type) {
            this.type = type;
        }

        public final Type getType() {
            return this.type;
        }

        public final Set<Annotation> getQualifiers() {
            return Collections.singleton(DefaultLiteral.INSTANCE);
        }

        public final Bean<?> getBean() {
            return null;
        }

        public final Member getMember() {
            return null;
        }

        public final Annotated getAnnotated() {
            return null;
        }

        public final boolean isDelegate() {
            return false;
        }

        public final boolean isTransient() {
            return false;
        }
    }
}

