/*
 * Decompiled with CFR 0.152.
 */
package org.microbean.microprofile.config.cdi;

import java.lang.annotation.Annotation;
import java.lang.reflect.Executable;
import java.lang.reflect.Field;
import java.lang.reflect.Member;
import java.lang.reflect.Parameter;
import java.lang.reflect.Type;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.enterprise.context.spi.CreationalContext;
import javax.enterprise.event.Observes;
import javax.enterprise.inject.spi.AfterBeanDiscovery;
import javax.enterprise.inject.spi.AfterDeploymentValidation;
import javax.enterprise.inject.spi.Annotated;
import javax.enterprise.inject.spi.AnnotatedCallable;
import javax.enterprise.inject.spi.AnnotatedField;
import javax.enterprise.inject.spi.AnnotatedMethod;
import javax.enterprise.inject.spi.AnnotatedParameter;
import javax.enterprise.inject.spi.AnnotatedType;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.BeanManager;
import javax.enterprise.inject.spi.DeploymentException;
import javax.enterprise.inject.spi.Extension;
import javax.enterprise.inject.spi.InjectionPoint;
import javax.enterprise.inject.spi.ProcessBean;
import javax.enterprise.inject.spi.ProcessObserverMethod;
import org.eclipse.microprofile.config.Config;
import org.eclipse.microprofile.config.inject.ConfigProperty;
import org.microbean.microprofile.config.cdi.AnyLiteral;
import org.microbean.microprofile.config.cdi.ConfigBean;
import org.microbean.microprofile.config.cdi.ConfigPropertyBean;
import org.microbean.microprofile.config.cdi.ConfigPropertyLiteral;
import org.microbean.microprofile.config.cdi.DefaultLiteral;

public final class ConfigExtension
implements Extension {
    private final Map<Set<Annotation>, Set<Type>> configPropertyTypes;
    private final Set<InjectionPoint> configPropertyInjectionPointsToValidate = new HashSet<InjectionPoint>();
    private final Set<Set<Annotation>> allConfigQualifiers;

    public ConfigExtension() {
        this.configPropertyTypes = new HashMap<Set<Annotation>, Set<Type>>();
        this.allConfigQualifiers = new HashSet<Set<Annotation>>();
    }

    private final <X> void processBean(@Observes ProcessBean<X> event) {
        Set beanInjectionPoints;
        Bean bean;
        if (event != null && (bean = event.getBean()) != null && (beanInjectionPoints = bean.getInjectionPoints()) != null && !beanInjectionPoints.isEmpty()) {
            for (InjectionPoint beanInjectionPoint : beanInjectionPoints) {
                if (beanInjectionPoint == null) continue;
                Set qualifiers = beanInjectionPoint.getQualifiers();
                assert (qualifiers != null);
                Type type = beanInjectionPoint.getType();
                assert (type != null);
                if (Config.class.equals((Object)type)) {
                    if (qualifiers.isEmpty()) continue;
                    HashSet<Annotation> configQualifiers = new HashSet<Annotation>(qualifiers);
                    if (configQualifiers.removeIf(q -> q instanceof ConfigProperty)) {
                        configQualifiers.add((Annotation)ConfigPropertyLiteral.INSTANCE);
                    }
                    configQualifiers.add((Annotation)AnyLiteral.INSTANCE);
                    this.allConfigQualifiers.add(configQualifiers);
                    continue;
                }
                Annotated annotated = beanInjectionPoint.getAnnotated();
                if (annotated == null || !annotated.isAnnotationPresent(ConfigProperty.class)) continue;
                this.configPropertyInjectionPointsToValidate.add(beanInjectionPoint);
                Set<Annotation> configPropertyQualifiers = new HashSet<Annotation>(qualifiers);
                configPropertyQualifiers.removeIf(q -> q instanceof ConfigProperty);
                configPropertyQualifiers.add((Annotation)ConfigPropertyLiteral.INSTANCE);
                configPropertyQualifiers = Collections.unmodifiableSet(configPropertyQualifiers);
                Set<Type> configPropertyTypes = this.configPropertyTypes.get(configPropertyQualifiers);
                if (configPropertyTypes == null) {
                    configPropertyTypes = new HashSet<Type>();
                    this.configPropertyTypes.put(configPropertyQualifiers, configPropertyTypes);
                }
                configPropertyTypes.add(type);
            }
        }
    }

    private final <T, X> void processObserverMethod(@Observes ProcessObserverMethod<T, X> event, BeanManager beanManager) {
        List annotatedParameters;
        AnnotatedMethod annotatedMethod;
        if (event != null && beanManager != null && (annotatedMethod = event.getAnnotatedMethod()) != null && (annotatedParameters = annotatedMethod.getParameters()) != null && annotatedParameters.size() > 1) {
            for (AnnotatedParameter annotatedParameter : annotatedParameters) {
                if (annotatedParameter == null || annotatedParameter.isAnnotationPresent(Observes.class)) continue;
                InjectionPoint injectionPoint = beanManager.createInjectionPoint(annotatedParameter);
                assert (injectionPoint != null);
                Type type = injectionPoint.getType();
                Set qualifiers = injectionPoint.getQualifiers();
                if (Config.class.equals((Object)type)) {
                    if (qualifiers == null || qualifiers.isEmpty()) continue;
                    HashSet<Annotation> configQualifiers = new HashSet<Annotation>(qualifiers);
                    if (configQualifiers.removeIf(q -> q instanceof ConfigProperty)) {
                        configQualifiers.add((Annotation)ConfigPropertyLiteral.INSTANCE);
                    }
                    configQualifiers.add((Annotation)AnyLiteral.INSTANCE);
                    this.allConfigQualifiers.add(Collections.unmodifiableSet(configQualifiers));
                    continue;
                }
                if (!annotatedParameter.isAnnotationPresent(ConfigProperty.class)) continue;
                this.configPropertyInjectionPointsToValidate.add(injectionPoint);
                Set<Annotation> configPropertyQualifiers = new HashSet<Annotation>(qualifiers);
                configPropertyQualifiers.removeIf(q -> q instanceof ConfigProperty);
                configPropertyQualifiers.add((Annotation)ConfigPropertyLiteral.INSTANCE);
                configPropertyQualifiers = Collections.unmodifiableSet(configPropertyQualifiers);
                Set<Type> configPropertyTypes = this.configPropertyTypes.get(configPropertyQualifiers);
                if (configPropertyTypes == null) {
                    configPropertyTypes = new HashSet<Type>();
                    this.configPropertyTypes.put(configPropertyQualifiers, configPropertyTypes);
                }
                configPropertyTypes.add(type);
            }
        }
    }

    private final void afterBeanDiscovery(@Observes AfterBeanDiscovery event, BeanManager beanManager) {
        if (event != null) {
            AnnotatedType configAnnotatedType = beanManager.createAnnotatedType(Config.class);
            assert (configAnnotatedType != null);
            HashSet<Object> defaultConfigQualifiers = new HashSet<Object>();
            defaultConfigQualifiers.add(AnyLiteral.INSTANCE);
            defaultConfigQualifiers.add(DefaultLiteral.INSTANCE);
            this.allConfigQualifiers.add(defaultConfigQualifiers);
            if (!this.configPropertyTypes.isEmpty()) {
                Set<Map.Entry<Set<Annotation>, Set<Type>>> entrySet = this.configPropertyTypes.entrySet();
                assert (entrySet != null);
                assert (!entrySet.isEmpty());
                for (Map.Entry<Set<Annotation>, Set<Type>> entry : entrySet) {
                    assert (entry != null);
                    Set<Annotation> qualifiers = entry.getKey();
                    assert (qualifiers != null);
                    Set<Type> types = entry.getValue();
                    assert (types != null);
                    HashSet<Type> newTypes = new HashSet<Type>(types);
                    Iterator iterator = newTypes.iterator();
                    assert (iterator != null);
                    while (iterator.hasNext()) {
                        Type type = (Type)iterator.next();
                        assert (type != null);
                        if (ConfigExtension.noBeans(beanManager, type, qualifiers)) continue;
                        iterator.remove();
                    }
                    event.addBean(new ConfigPropertyBean(newTypes, qualifiers));
                }
            }
            for (Set<Annotation> configQualifiers : this.allConfigQualifiers) {
                if (!ConfigExtension.noBeans(beanManager, Config.class, configQualifiers)) continue;
                event.addBean((Bean)new ConfigBean(configQualifiers));
            }
        }
        this.allConfigQualifiers.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void afterDeploymentValidation(@Observes AfterDeploymentValidation event, BeanManager beanManager) {
        if (event != null && beanManager != null) {
            CreationalContext cc = beanManager.createCreationalContext(null);
            try {
                for (InjectionPoint injectionPoint : this.configPropertyInjectionPointsToValidate) {
                    assert (injectionPoint != null);
                    if (beanManager.getInjectableReference(injectionPoint, cc) != null) continue;
                    event.addDeploymentProblem((Throwable)new DeploymentException("No value exists for the mandatory configuration property named " + ConfigExtension.getConfigPropertyName(injectionPoint)));
                }
            }
            finally {
                cc.release();
            }
        }
        this.configPropertyInjectionPointsToValidate.clear();
        this.configPropertyTypes.clear();
    }

    private static final boolean noBeans(BeanManager beanManager, Type type, Set<Annotation> qualifiers) {
        Objects.requireNonNull(beanManager);
        Objects.requireNonNull(type);
        Set beans = qualifiers == null || qualifiers.isEmpty() ? beanManager.getBeans(type, new Annotation[0]) : beanManager.getBeans(type, qualifiers.toArray(new Annotation[qualifiers.size()]));
        return beans == null || beans.isEmpty();
    }

    static final String getConfigPropertyName(InjectionPoint injectionPoint) {
        return ConfigExtension.getConfigPropertyName(injectionPoint, null);
    }

    static final String getConfigPropertyName(InjectionPoint injectionPoint, ConfigProperty configProperty) {
        String name = null;
        if (injectionPoint != null) {
            Set qualifiers;
            if (configProperty == null && (qualifiers = injectionPoint.getQualifiers()) != null) {
                for (Annotation qualifier : qualifiers) {
                    if (qualifier == null || !ConfigProperty.class.equals(qualifier.annotationType())) continue;
                    configProperty = (ConfigProperty)qualifier;
                    break;
                }
            }
            if (configProperty != null) {
                name = configProperty.name();
                assert (name != null);
                if (name.isEmpty()) {
                    Annotated annotated = injectionPoint.getAnnotated();
                    if (annotated instanceof AnnotatedField) {
                        AnnotatedType declaringType;
                        AnnotatedField field = (AnnotatedField)annotated;
                        Field member = field.getJavaMember();
                        if (member != null && (declaringType = field.getDeclaringType()) != null) {
                            name = declaringType.getJavaClass().getCanonicalName() + "." + member.getName();
                        }
                    } else if (annotated instanceof AnnotatedParameter) {
                        AnnotatedParameter annotatedParameter = (AnnotatedParameter)annotated;
                        AnnotatedCallable declaringCallable = annotatedParameter.getDeclaringCallable();
                        if (declaringCallable != null) {
                            Member member = declaringCallable.getJavaMember();
                            assert (member instanceof Executable);
                            Executable executable = (Executable)member;
                            int position = annotatedParameter.getPosition();
                            Parameter[] parameters = executable.getParameters();
                            if (parameters != null && parameters.length > position) {
                                AnnotatedType declaringType;
                                Parameter parameter = parameters[position];
                                assert (parameter != null);
                                if (parameter.isNamePresent() && (declaringType = declaringCallable.getDeclaringType()) != null) {
                                    name = declaringType.getJavaClass().getCanonicalName() + "." + parameter.getName();
                                }
                            }
                        }
                    } else assert (false);
                }
            }
        }
        return name;
    }
}

