/*
 * Decompiled with CFR 0.152.
 */
package org.microbean.microprofile.config.cdi;

import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Set;
import javax.enterprise.context.spi.CreationalContext;
import javax.enterprise.inject.Instance;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.CDI;
import javax.enterprise.inject.spi.InjectionPoint;
import javax.enterprise.inject.spi.PassivationCapable;
import javax.enterprise.util.TypeLiteral;
import javax.inject.Singleton;
import org.eclipse.microprofile.config.Config;
import org.eclipse.microprofile.config.ConfigProvider;
import org.eclipse.microprofile.config.spi.ConfigBuilder;
import org.eclipse.microprofile.config.spi.ConfigProviderResolver;
import org.eclipse.microprofile.config.spi.ConfigSource;
import org.eclipse.microprofile.config.spi.Converter;
import org.microbean.microprofile.config.cdi.AnyLiteral;
import org.microbean.microprofile.config.cdi.DefaultLiteral;

final class ConfigBean
implements Bean<Config>,
PassivationCapable {
    private static final Set<Annotation> onlyDefaultQualifier = Collections.singleton(DefaultLiteral.INSTANCE);
    private static final Set<Annotation> defaultQualifiers = new HashSet<Annotation>();
    private static final Set<InjectionPoint> emptyInjectionPointSet;
    private static final Set<Class<? extends Annotation>> emptyStereotypesSet;
    private static final Set<Type> configTypes;
    private final String id;
    private final Set<Annotation> qualifiers;

    ConfigBean() {
        this(null);
    }

    ConfigBean(Set<Annotation> qualifiers) {
        HashSet<Object> myQualifiers = qualifiers == null || qualifiers.isEmpty() ? new HashSet() : new HashSet<Annotation>(qualifiers);
        this.qualifiers = Collections.unmodifiableSet(myQualifiers);
        this.id = this.getClass().getName() + ";t:" + this.getTypes() + ";q:" + this.getQualifiers();
    }

    public final Config create(CreationalContext<Config> cc) {
        Config returnValue;
        Set<Annotation> myQualifiers = this.getQualifiers();
        assert (myQualifiers != null);
        if (myQualifiers.equals(onlyDefaultQualifier) || myQualifiers.equals(defaultQualifiers)) {
            returnValue = ConfigProvider.getConfig();
            assert (returnValue != null);
        } else {
            Instance converterInstance;
            ConfigBuilder builder = ConfigProviderResolver.instance().getBuilder();
            assert (builder != null);
            builder.addDefaultSources();
            builder.addDiscoveredSources();
            builder.addDiscoveredConverters();
            builder.forClassLoader(Thread.currentThread().getContextClassLoader());
            CDI cdi = CDI.current();
            assert (cdi != null);
            Annotation[] myQualifiersArray = myQualifiers.toArray(new Annotation[myQualifiers.size()]);
            Instance configSourceInstance = cdi.select(ConfigSource.class, myQualifiersArray);
            if (configSourceInstance != null && !configSourceInstance.isUnsatisfied()) {
                LinkedList<ConfigSource> configSources = new LinkedList<ConfigSource>();
                for (ConfigSource configSource : configSourceInstance) {
                    assert (configSource != null);
                    configSources.add(configSource);
                }
                assert (!configSources.isEmpty());
                builder.withSources(configSources.toArray(new ConfigSource[configSources.size()]));
            }
            if ((converterInstance = cdi.select(new TypeLiteral<Converter<?>>(){
                private static final long serialVersionUID = 1L;
            }, myQualifiersArray)) != null && !converterInstance.isUnsatisfied()) {
                LinkedList<Converter> converters = new LinkedList<Converter>();
                for (Converter converter : converterInstance) {
                    assert (converter != null);
                    converters.add(converter);
                }
                assert (!converters.isEmpty());
                builder.withConverters(converters.toArray(new Converter[converters.size()]));
            }
            returnValue = builder.build();
        }
        return returnValue;
    }

    public void destroy(Config config, CreationalContext<Config> cc) {
        try {
            if (config != null) {
                ConfigProviderResolver.instance().releaseConfig(config);
            }
        }
        finally {
            if (cc != null) {
                cc.release();
            }
        }
    }

    public final Class<?> getBeanClass() {
        return ConfigBean.class;
    }

    public final String getId() {
        return this.id;
    }

    public final Set<InjectionPoint> getInjectionPoints() {
        return emptyInjectionPointSet;
    }

    public final String getName() {
        return "config";
    }

    public final Set<Annotation> getQualifiers() {
        return this.qualifiers;
    }

    public final Class<? extends Annotation> getScope() {
        return Singleton.class;
    }

    public final Set<Class<? extends Annotation>> getStereotypes() {
        return emptyStereotypesSet;
    }

    public final Set<Type> getTypes() {
        return configTypes;
    }

    public final boolean isAlternative() {
        return false;
    }

    public final boolean isNullable() {
        return false;
    }

    public final String toString() {
        return this.getClass().getName() + " " + this.getQualifiers();
    }

    static {
        defaultQualifiers.add((Annotation)DefaultLiteral.INSTANCE);
        defaultQualifiers.add((Annotation)AnyLiteral.INSTANCE);
        emptyInjectionPointSet = Collections.emptySet();
        emptyStereotypesSet = Collections.emptySet();
        configTypes = Collections.singleton(Config.class);
    }
}

