/*
 * Decompiled with CFR 0.152.
 */
package org.microbean.microprofile.config;

import java.security.AccessController;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.microbean.microprofile.config.AbstractConfigSource;

class SystemPropertiesConfigSource
extends AbstractConfigSource {
    private static final long serialVersionUID = 1L;

    SystemPropertiesConfigSource() {
        super("System properties", 400);
    }

    public Map<String, String> getProperties() {
        Properties systemProperties = AccessController.doPrivileged(() -> System.getProperties());
        assert (systemProperties != null);
        LinkedHashMap<String, String> returnValue = new LinkedHashMap<String, String>();
        Set<String> systemPropertyNames = this.getPropertyNames();
        assert (systemPropertyNames != null);
        for (String name : systemPropertyNames) {
            assert (name != null);
            returnValue.put(name, systemProperties.getProperty(name));
        }
        return Collections.unmodifiableMap(returnValue);
    }

    public Set<String> getPropertyNames() {
        Properties systemProperties = AccessController.doPrivileged(() -> System.getProperties());
        assert (systemProperties != null);
        return systemProperties.stringPropertyNames();
    }

    public String getValue(String name) {
        return AccessController.doPrivileged(() -> System.getProperty(name));
    }
}

