/*
 * Decompiled with CFR 0.152.
 */
package org.microbean.microprofile.config;

import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.microbean.microprofile.config.AbstractConfigSource;

class PropertiesConfigSource
extends AbstractConfigSource {
    private static final long serialVersionUID = 1L;
    private final Properties properties;

    PropertiesConfigSource(Properties properties, String name) {
        this(properties, name, null);
    }

    PropertiesConfigSource(Properties properties, String name, Integer ordinal) {
        super(name, ordinal);
        this.properties = properties;
    }

    public Map<String, String> getProperties() {
        Map<String, String> returnValue = null;
        Set<String> propertyNames = this.getPropertyNames();
        if (propertyNames != null && !propertyNames.isEmpty()) {
            returnValue = new LinkedHashMap();
            for (String propertyName : propertyNames) {
                if (propertyName == null) continue;
                returnValue.put(propertyName, this.properties.getProperty(propertyName));
            }
        }
        returnValue = returnValue == null || returnValue.isEmpty() ? Collections.emptyMap() : Collections.unmodifiableMap(returnValue);
        return returnValue;
    }

    public Set<String> getPropertyNames() {
        Set<String> returnValue = this.properties == null ? Collections.emptySet() : this.properties.stringPropertyNames();
        return returnValue;
    }

    public String getValue(String name) {
        String returnValue = this.properties == null ? null : this.properties.getProperty(name);
        return returnValue;
    }
}

