/*
 * Decompiled with CFR 0.152.
 */
package org.microbean.microprofile.config;

import java.lang.reflect.Type;
import java.util.Objects;
import org.eclipse.microprofile.config.spi.Converter;

final class PrioritizedConverter<T>
implements Converter<T> {
    private static final long serialVersionUID = 1L;
    private final Converter<T> delegate;
    private final Type conversionType;
    private final Integer priority;

    PrioritizedConverter(Converter<T> delegate, Type conversionType, int priority) {
        this(delegate, conversionType, (Integer)priority);
    }

    PrioritizedConverter(Converter<T> delegate, Type conversionType, Integer priority) {
        this.delegate = Objects.requireNonNull(delegate);
        this.conversionType = Objects.requireNonNull(conversionType);
        this.priority = priority;
    }

    final int getPriority() {
        int returnValue = this.priority == null ? 100 : this.priority;
        return returnValue;
    }

    Type getConversionType() {
        return this.conversionType;
    }

    public final T convert(String value) {
        return (T)this.delegate.convert(value);
    }

    public int hashCode() {
        int hashCode = 17;
        Converter<T> delegate = this.delegate;
        int c = delegate == null ? 0 : delegate.hashCode();
        hashCode = 37 * hashCode + c;
        Type conversionType = this.conversionType;
        c = conversionType == null ? 0 : conversionType.hashCode();
        hashCode = 37 * hashCode + c;
        hashCode = 37 * hashCode + this.getPriority();
        return hashCode;
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (other instanceof PrioritizedConverter) {
            PrioritizedConverter her = (PrioritizedConverter)other;
            if (this.delegate == null ? her.delegate != null : !this.delegate.equals(her.delegate)) {
                return false;
            }
            if (this.conversionType == null ? her.conversionType != null : !this.conversionType.equals(her.conversionType)) {
                return false;
            }
            return this.getPriority() == her.getPriority();
        }
        return false;
    }
}

