/*
 * Decompiled with CFR 0.152.
 */
package org.microbean.microprofile.config;

import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Optional;
import java.util.Properties;
import java.util.Set;
import org.eclipse.microprofile.config.Config;
import org.eclipse.microprofile.config.ConfigProvider;

public class MicroProfileConfigProperties
extends Properties {
    private static final long serialVersionUID = 1L;
    private final Config config;
    private boolean iterating;

    public MicroProfileConfigProperties() {
        this(null, null);
    }

    public MicroProfileConfigProperties(Config config) {
        this(config, null);
    }

    public MicroProfileConfigProperties(Properties defaults) {
        this(null, defaults);
    }

    public MicroProfileConfigProperties(Config config, Properties defaults) {
        super(defaults);
        this.config = config == null ? ConfigProvider.getConfig() : config;
    }

    @Override
    public final synchronized boolean containsKey(Object key) {
        boolean returnValue;
        block4: {
            Iterable propertyNames;
            returnValue = super.containsKey(key);
            if (returnValue || (propertyNames = this.config.getPropertyNames()) == null) break block4;
            if (key == null) {
                for (Object propertyName : propertyNames) {
                    if (propertyName != null) continue;
                    returnValue = true;
                    break;
                }
            } else {
                for (Object propertyName : propertyNames) {
                    if (!key.equals(propertyName)) continue;
                    returnValue = true;
                    break;
                }
            }
        }
        return returnValue;
    }

    @Override
    public final synchronized boolean contains(Object value) {
        return this.containsValue(value);
    }

    @Override
    public final synchronized boolean containsValue(Object value) {
        boolean returnValue = super.containsValue(value);
        if (!returnValue) {
            Iterable propertyNames = this.config.getPropertyNames();
            if (propertyNames == null) {
                returnValue = false;
            } else {
                for (String propertyName : propertyNames) {
                    Optional propertyValue = this.config.getOptionalValue(propertyName, String.class);
                    if (propertyValue == null || !propertyValue.isPresent()) continue;
                    returnValue = true;
                    break;
                }
            }
        }
        return returnValue;
    }

    @Override
    public final synchronized String getProperty(String key) {
        Object propertyValue = this.get(key);
        String returnValue = propertyValue instanceof String ? (String)propertyValue : (this.defaults != null ? this.defaults.getProperty(key) : null);
        return returnValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final synchronized Object get(Object key) {
        Object returnValue;
        if (super.containsKey(key) || this.iterating) {
            returnValue = super.get(key);
        } else {
            this.iterating = true;
            try {
                Optional configValue = this.config.getOptionalValue(key.toString(), String.class);
                returnValue = configValue == null || !configValue.isPresent() ? null : configValue.get();
            }
            finally {
                this.iterating = false;
            }
        }
        return returnValue;
    }

    @Override
    public final synchronized boolean isEmpty() {
        Iterable propertyNames;
        boolean returnValue = super.isEmpty();
        if (returnValue && (propertyNames = this.config.getPropertyNames()) != null) {
            Iterator iterator = propertyNames.iterator();
            returnValue = iterator != null && iterator.hasNext();
        }
        return returnValue;
    }

    @Override
    public final synchronized int size() {
        return this.keySet().size();
    }

    @Override
    public final synchronized Enumeration<Object> keys() {
        return new IteratorEnumeration<Object>(this.keySet());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final synchronized Set<Object> keySet() {
        Set<Object> returnValue;
        block11: {
            if (this.iterating) {
                returnValue = Collections.unmodifiableSet(super.keySet());
            } else {
                this.iterating = true;
                try {
                    Iterable configKeys = this.config.getPropertyNames();
                    if (configKeys == null) {
                        returnValue = Collections.unmodifiableSet(super.keySet());
                        break block11;
                    }
                    LinkedHashSet<Object> keys = new LinkedHashSet<Object>();
                    Set<Object> superKeys = super.keySet();
                    if (superKeys != null && !superKeys.isEmpty()) {
                        keys.addAll(superKeys);
                    }
                    Iterable iterable = configKeys;
                    synchronized (iterable) {
                        for (Object configKey : configKeys) {
                            keys.add(configKey);
                        }
                    }
                    returnValue = Collections.unmodifiableSet(keys);
                }
                finally {
                    this.iterating = false;
                }
            }
        }
        return returnValue;
    }

    @Override
    public final synchronized Enumeration<Object> elements() {
        return new IteratorEnumeration<Object>(this.values());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final synchronized Collection<Object> values() {
        Collection<Object> returnValue;
        block11: {
            if (this.iterating) {
                returnValue = Collections.unmodifiableCollection(super.values());
            } else {
                this.iterating = true;
                try {
                    Iterable configKeys = this.config.getPropertyNames();
                    if (configKeys == null) {
                        returnValue = Collections.unmodifiableCollection(super.values());
                        break block11;
                    }
                    ArrayList<Object> values = new ArrayList<Object>(super.values());
                    Iterable iterable = configKeys;
                    synchronized (iterable) {
                        for (Object configKey : configKeys) {
                            Optional configValue = this.config.getOptionalValue(String.valueOf(configKey), String.class);
                            if (configValue == null || !configValue.isPresent()) {
                                values.add(null);
                                continue;
                            }
                            values.add(configValue.get());
                        }
                    }
                    returnValue = Collections.unmodifiableCollection(values);
                }
                finally {
                    this.iterating = false;
                }
            }
        }
        return returnValue;
    }

    @Override
    public final synchronized Set<Map.Entry<Object, Object>> entrySet() {
        Set<Map.Entry<Object, Object>> returnValue;
        Set<Object> keySet = this.keySet();
        if (keySet.isEmpty()) {
            returnValue = Collections.emptySet();
        } else {
            LinkedHashSet<AbstractMap.SimpleImmutableEntry<Object, Object>> entrySet = new LinkedHashSet<AbstractMap.SimpleImmutableEntry<Object, Object>>();
            for (Object key : keySet) {
                entrySet.add(new AbstractMap.SimpleImmutableEntry<Object, Object>(key, this.get(key)));
            }
            returnValue = Collections.unmodifiableSet(entrySet);
        }
        return returnValue;
    }

    public static final void installAsSystemProperties() {
        AccessController.doPrivileged(new PrivilegedAction<Void>(){

            @Override
            public final Void run() {
                System.setProperties(new MicroProfileConfigProperties(System.getProperties()));
                return null;
            }
        });
    }

    private static final class IteratorEnumeration<T>
    implements Enumeration<T>,
    Iterator<T> {
        private final Iterator<? extends T> iterator;
        private final Enumeration<? extends T> enumeration;

        private IteratorEnumeration(Iterable<? extends T> iterable) {
            this(iterable == null ? (Iterator<? extends T>)null : iterable.iterator());
        }

        private IteratorEnumeration(Iterator<? extends T> iterator) {
            this.iterator = iterator;
            this.enumeration = null;
        }

        private IteratorEnumeration(Enumeration<? extends T> enumeration) {
            this.iterator = null;
            this.enumeration = enumeration;
        }

        @Override
        public final boolean hasMoreElements() {
            if (this.enumeration == null) {
                return this.iterator != null && this.iterator.hasNext();
            }
            return this.enumeration.hasMoreElements();
        }

        @Override
        public final T nextElement() {
            if (this.enumeration == null) {
                if (this.iterator == null) {
                    throw new NoSuchElementException();
                }
                return this.iterator.next();
            }
            return this.enumeration.nextElement();
        }

        @Override
        public final boolean hasNext() {
            if (this.iterator == null) {
                return this.enumeration != null && this.enumeration.hasMoreElements();
            }
            return this.iterator.hasNext();
        }

        @Override
        public final T next() {
            if (this.iterator == null) {
                if (this.enumeration == null) {
                    throw new NoSuchElementException();
                }
                return this.enumeration.nextElement();
            }
            return this.iterator.next();
        }

        @Override
        public void remove() {
            if (this.iterator == null) {
                throw new UnsupportedOperationException();
            }
            this.iterator.remove();
        }
    }
}

