/*
 * Decompiled with CFR 0.152.
 */
package org.microbean.microprofile.config;

import java.security.AccessController;
import java.util.Map;
import java.util.regex.Pattern;
import org.microbean.microprofile.config.AbstractConfigSource;

class EnvironmentVariablesConfigSource
extends AbstractConfigSource {
    private static final long serialVersionUID = 1L;
    private static final Pattern toUnderscorePattern = Pattern.compile("[^a-zA-Z0-9_]");

    EnvironmentVariablesConfigSource() {
        super("Environment", 300);
    }

    public Map<String, String> getProperties() {
        return AccessController.doPrivileged(() -> System.getenv());
    }

    public String getValue(String name) {
        return AccessController.doPrivileged(() -> {
            String doctoredName;
            String value = System.getenv(name);
            if (value == null && (value = System.getenv(doctoredName = toUnderscorePattern.matcher(name).replaceAll("_"))) == null) {
                value = System.getenv(doctoredName.toUpperCase());
            }
            return value;
        });
    }
}

