/*
 * Decompiled with CFR 0.152.
 */
package org.microbean.microprofile.config;

import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.GenericDeclaration;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Priority;
import org.eclipse.microprofile.config.spi.Converter;
import org.microbean.microprofile.config.PrioritizedConverter;

final class Converters {
    private Converters() {
    }

    static final Type getConversionType(Converter<?> converter) {
        Type returnValue = converter instanceof PrioritizedConverter ? ((PrioritizedConverter)converter).getConversionType() : Converters.getConversionType(Objects.requireNonNull(converter).getClass());
        return returnValue;
    }

    static final int getPriority(Converter<?> converter) {
        int returnValue = 100;
        if (converter != null) {
            if (converter instanceof PrioritizedConverter) {
                returnValue = ((PrioritizedConverter)converter).getPriority();
            } else {
                Integer priorityInteger = Converters.getPriority(converter.getClass());
                if (priorityInteger != null) {
                    returnValue = priorityInteger;
                }
            }
        }
        return returnValue;
    }

    private static final Integer getPriority(AnnotatedElement annotatedElement) {
        Priority priority;
        Integer returnValue = null;
        if (annotatedElement != null && (priority = annotatedElement.getAnnotation(Priority.class)) != null) {
            returnValue = priority.value();
        }
        return returnValue;
    }

    static final Type getConversionType(Type type) {
        return Converters.getConversionType(type, null, null);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final Type getConversionType(Type type, Set<Type> seen, Map<TypeVariable<?>, Type> reifiedTypes) {
        Type returnValue = null;
        if (type == null) return returnValue;
        if (seen == null) {
            seen = new HashSet<Type>();
        }
        if (reifiedTypes == null) {
            reifiedTypes = new HashMap();
        }
        if (seen.contains(type)) return returnValue;
        seen.add(type);
        if (type instanceof Class) {
            Type genericInterface;
            Class c = (Class)type;
            if (!Converter.class.isAssignableFrom(c)) return returnValue;
            Type[] genericInterfaces = c.getGenericInterfaces();
            assert (genericInterfaces != null);
            Type[] typeArray = genericInterfaces;
            int n = typeArray.length;
            for (int i = 0; i < n && (returnValue = Converters.getConversionType(genericInterface = typeArray[i], seen, reifiedTypes)) == null; ++i) {
            }
            if (returnValue != null) return returnValue;
            return Converters.getConversionType(c.getSuperclass(), seen, reifiedTypes);
        }
        if (!(type instanceof ParameterizedType)) throw new IllegalArgumentException("Unhandled type: " + type);
        ParameterizedType pt = (ParameterizedType)type;
        Type rawType = pt.getRawType();
        assert (rawType instanceof GenericDeclaration);
        TypeVariable<?>[] typeParameters = ((GenericDeclaration)((Object)rawType)).getTypeParameters();
        assert (typeParameters != null);
        Type[] actualTypeArguments = pt.getActualTypeArguments();
        assert (actualTypeArguments != null);
        assert (actualTypeArguments.length == typeParameters.length);
        if (actualTypeArguments.length > 0) {
            for (int i = 0; i < actualTypeArguments.length; ++i) {
                Object actualTypeArgument = actualTypeArguments[i];
                if (actualTypeArgument instanceof Class || actualTypeArgument instanceof ParameterizedType) {
                    reifiedTypes.put(typeParameters[i], (Type)actualTypeArgument);
                    continue;
                }
                if (!(actualTypeArgument instanceof TypeVariable)) continue;
                Type reifiedType = reifiedTypes.get((TypeVariable)actualTypeArgument);
                if (reifiedType == null) {
                    reifiedTypes.put((TypeVariable)actualTypeArgument, (Type)((Object)Object.class));
                    actualTypeArgument = Object.class;
                } else {
                    actualTypeArgument = reifiedType;
                }
                assert (actualTypeArgument != null);
                assert (actualTypeArgument instanceof ParameterizedType || actualTypeArgument instanceof Class) : "Unexpected actualTypeArgument: " + actualTypeArgument;
                reifiedTypes.put(typeParameters[i], (Type)actualTypeArgument);
            }
        }
        if (!Converter.class.equals((Object)rawType)) return Converters.getConversionType(rawType, seen, reifiedTypes);
        assert (actualTypeArguments.length == 1);
        Type typeArgument = actualTypeArguments[0];
        if (typeArgument instanceof Class) return typeArgument;
        if (typeArgument instanceof ParameterizedType) {
            return typeArgument;
        }
        if (!(typeArgument instanceof TypeVariable)) throw new IllegalArgumentException("Unhandled conversion type: " + typeArgument);
        TypeVariable typeVariable = (TypeVariable)typeArgument;
        returnValue = reifiedTypes.get(typeVariable);
        if ($assertionsDisabled) return returnValue;
        if (returnValue instanceof ParameterizedType) return returnValue;
        if (returnValue instanceof Class) return returnValue;
        throw new AssertionError((Object)("Unexpected returnValue: " + returnValue));
    }
}

