/*
 * Decompiled with CFR 0.152.
 */
package org.microbean.microprofile.config;

import java.beans.PropertyEditor;
import java.beans.PropertyEditorManager;
import java.io.Closeable;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.Executable;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.security.AccessController;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.ServiceLoader;
import java.util.Set;
import java.util.regex.Pattern;
import org.eclipse.microprofile.config.spi.Converter;
import org.microbean.microprofile.config.Converters;
import org.microbean.microprofile.config.TypeConverter;

public class ConversionHub
implements Closeable,
Serializable,
TypeConverter {
    private static final long serialVersionUID = 1L;
    private static final Pattern splitPattern = Pattern.compile("(?<!\\\\),");
    private static final Pattern backslashCommaPattern = Pattern.compile("\\\\,");
    private static final Map<Class<?>, Class<?>> wrapperClasses = new HashMap();
    private final Map<Type, Converter<?>> converters;
    private volatile boolean closed;

    public ConversionHub() {
        Map<? extends Type, ? extends Converter<?>> discoveredConverters = ConversionHub.getDiscoveredConverters(null);
        this.converters = new HashMap(discoveredConverters);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ConversionHub(Map<? extends Type, ? extends Converter<?>> converters) {
        if (converters == null) {
            this.converters = new HashMap();
        } else {
            Map<? extends Type, ? extends Converter<?>> map = converters;
            synchronized (map) {
                this.converters = new HashMap(converters);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        if (!this.isClosed()) {
            IOException throwMe = null;
            Map<Type, Converter<?>> map = this.converters;
            synchronized (map) {
                if (!this.converters.isEmpty()) {
                    Collection<Converter<?>> converters = this.converters.values();
                    assert (converters != null);
                    assert (!converters.isEmpty());
                    for (Converter<?> converter : converters) {
                        if (!(converter instanceof Closeable)) continue;
                        try {
                            ((Closeable)converter).close();
                        }
                        catch (IOException ioException) {
                            if (throwMe == null) {
                                throwMe = ioException;
                                continue;
                            }
                            throwMe.addSuppressed(ioException);
                        }
                    }
                }
            }
            if (throwMe != null) {
                throw throwMe;
            }
            this.closed = true;
        }
    }

    public final boolean isClosed() {
        return this.closed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final <T> T convert(String value, Type type) {
        Object converter;
        if (this.isClosed()) {
            throw new IllegalStateException("this.isClosed()");
        }
        Map<Type, Converter<?>> map = this.converters;
        synchronized (map) {
            converter = this.converters.get(type);
            if (converter == null) {
                try {
                    converter = this.computeConverter(type);
                }
                catch (ReflectiveOperationException reflectiveOperationException) {
                    throw new IllegalArgumentException(reflectiveOperationException.getMessage(), reflectiveOperationException);
                }
                if (converter != null) {
                    this.converters.put(type, (Converter<?>)converter);
                }
            }
        }
        if (converter == null) {
            throw new IllegalArgumentException("\"" + value + "\" could not be converted to " + (type == null ? "null" : type.getTypeName()));
        }
        Object returnValue = converter.convert(value);
        return (T)returnValue;
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final <T> Converter<T> computeConverter(Type conversionType) throws ReflectiveOperationException {
        void var2_24;
        Object var2_2 = null;
        if (CharSequence.class.equals((Object)conversionType) || String.class.equals((Object)conversionType) || Serializable.class.equals((Object)conversionType) || Object.class.equals((Object)conversionType)) {
            SerializableConverter serializableConverter = new SerializableConverter<T>(){
                private static final long serialVersionUID = 1L;

                public final T convert(String rawValue) {
                    return rawValue;
                }
            };
            return var2_24;
        } else if (Boolean.class.equals((Object)conversionType) || Boolean.TYPE.equals(conversionType)) {
            SerializableConverter serializableConverter = new SerializableConverter<T>(){
                private static final long serialVersionUID = 1L;

                public final T convert(String rawValue) {
                    return rawValue != null && ("true".equalsIgnoreCase(rawValue) || "y".equalsIgnoreCase(rawValue) || "yes".equalsIgnoreCase(rawValue) || "on".equalsIgnoreCase(rawValue) || "1".equals(rawValue));
                }
            };
            return var2_24;
        } else if (Character.class.equals((Object)conversionType) || Character.TYPE.equals(conversionType)) {
            SerializableConverter serializableConverter = new SerializableConverter<T>(){
                private static final long serialVersionUID = 1L;

                public final T convert(String rawValue) {
                    if (rawValue == null || rawValue.isEmpty()) {
                        return null;
                    }
                    if (rawValue.length() != 1) {
                        throw new IllegalArgumentException("Unexpected length for character conversion: " + rawValue);
                    }
                    return Character.valueOf(rawValue.charAt(0));
                }
            };
            return var2_24;
        } else if (URL.class.equals((Object)conversionType)) {
            SerializableConverter serializableConverter = new SerializableConverter<T>(){
                private static final long serialVersionUID = 1L;

                public final T convert(String rawValue) {
                    try {
                        return URI.create(rawValue).toURL();
                    }
                    catch (MalformedURLException malformedUrlException) {
                        throw new IllegalArgumentException(malformedUrlException.getMessage(), malformedUrlException);
                    }
                }
            };
            return var2_24;
        } else if (Class.class.equals((Object)conversionType)) {
            SerializableConverter serializableConverter = new SerializableConverter<T>(){
                private static final long serialVersionUID = 1L;

                public final T convert(String rawValue) {
                    try {
                        return Class.forName(rawValue);
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new IllegalArgumentException(classNotFoundException.getMessage(), classNotFoundException);
                    }
                }
            };
            return var2_24;
        } else if (conversionType instanceof ParameterizedType) {
            ParameterizedType parameterizedType = (ParameterizedType)conversionType;
            final Type[] actualTypeArguments = parameterizedType.getActualTypeArguments();
            assert (actualTypeArguments != null);
            assert (actualTypeArguments.length > 0);
            Type rawType = parameterizedType.getRawType();
            assert (rawType instanceof Class) : "!(parameterizedType.getRawType() instanceof Class): " + rawType;
            final Class conversionClass = (Class)rawType;
            assert (!conversionClass.isArray());
            if (Optional.class.isAssignableFrom(conversionClass)) {
                assert (actualTypeArguments.length == 1);
                final Type firstTypeArgument = actualTypeArguments[0];
                SerializableConverter serializableConverter = new SerializableConverter<T>(){
                    private static final long serialVersionUID = 1L;

                    public final T convert(String rawValue) {
                        return Optional.ofNullable(ConversionHub.this.convert(rawValue, firstTypeArgument));
                    }
                };
                return var2_24;
            } else if (Class.class.isAssignableFrom(conversionClass)) {
                SerializableConverter serializableConverter = new SerializableConverter<T>(){
                    private static final long serialVersionUID = 1L;

                    public final T convert(String rawValue) {
                        return ConversionHub.this.convert(rawValue, conversionClass);
                    }
                };
                return var2_24;
            } else {
                if (!Collection.class.isAssignableFrom(conversionClass)) throw new IllegalArgumentException("Unhandled conversion type: " + conversionType);
                SerializableConverter serializableConverter = new SerializableConverter<T>(){
                    private static final long serialVersionUID = 1L;

                    public final T convert(String rawValue) {
                        Collection container = null;
                        if (conversionClass.isInterface()) {
                            container = Set.class.isAssignableFrom(conversionClass) ? new HashSet() : new ArrayList();
                        } else {
                            try {
                                container = (Collection)conversionClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                            }
                            catch (ReflectiveOperationException reflectiveOperationException) {
                                throw new IllegalArgumentException(reflectiveOperationException.getMessage(), reflectiveOperationException);
                            }
                        }
                        assert (container != null);
                        Type firstTypeArgument = actualTypeArguments[0];
                        String[] parts = ConversionHub.split(rawValue);
                        assert (parts != null);
                        assert (parts.length > 0);
                        for (String part : parts) {
                            Object scalar = ConversionHub.this.convert(part, firstTypeArgument);
                            container.add(scalar);
                        }
                        Collection temp = container;
                        return temp;
                    }
                };
            }
            return var2_24;
        } else {
            if (!(conversionType instanceof Class)) return var2_24;
            final Class<?> conversionClass = (Class<?>)conversionType;
            if (conversionClass.isArray()) {
                SerializableConverter serializableConverter = new SerializableConverter<T>(){
                    private static final long serialVersionUID = 1L;

                    public final T convert(String rawValue) {
                        String[] parts = ConversionHub.split(rawValue);
                        assert (parts != null);
                        Object container = Array.newInstance(conversionClass.getComponentType(), parts.length);
                        for (int i = 0; i < parts.length; ++i) {
                            Object scalar = ConversionHub.this.convert(parts[i], conversionClass.getComponentType());
                            Array.set(container, i, scalar);
                        }
                        return container;
                    }
                };
                return var2_24;
            } else {
                PropertyEditor editor;
                Converter<?> converter;
                Converter<?> converter2;
                Converter<T> converter3;
                Converter<T> converter4;
                Converter<T> converter5;
                Converter<T> converter6;
                Converter<T> converter7;
                Converter<T> converter8;
                Class<?> cls;
                if (conversionClass.isPrimitive()) {
                    cls = wrapperClasses.get(conversionClass);
                    assert (cls != null);
                } else {
                    cls = conversionClass;
                }
                if ((converter8 = ConversionHub.getConverterFromStaticMethod(cls, "of", String.class)) != null || (converter7 = ConversionHub.getConverterFromStaticMethod(cls, "of", CharSequence.class)) != null || (converter6 = ConversionHub.getConverterFromStaticMethod(cls, "valueOf", String.class)) != null || (converter5 = ConversionHub.getConverterFromStaticMethod(cls, "valueOf", CharSequence.class)) != null || (converter4 = ConversionHub.getConverterFromStaticMethod(cls, "parse", String.class)) != null || (converter3 = ConversionHub.getConverterFromStaticMethod(cls, "parse", CharSequence.class)) != null || (converter2 = ConversionHub.getConverterFromConstructor(cls, String.class)) != null || (converter = ConversionHub.getConverterFromConstructor(cls, CharSequence.class)) != null || (editor = PropertyEditorManager.findEditor(cls)) == null) return var2_24;
                PropertyEditorConverter propertyEditorConverter = new PropertyEditorConverter(cls, editor);
            }
        }
        return var2_24;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final <T> Converter<T> getConverterFromStaticMethod(Class<?> methodHostClass, String methodName, Class<? extends CharSequence> soleParameterType) {
        Method method;
        Objects.requireNonNull(methodHostClass);
        Objects.requireNonNull(methodName);
        Objects.requireNonNull(soleParameterType);
        if (methodHostClass.isArray()) {
            throw new IllegalArgumentException("methodHostClass.isArray(): " + methodHostClass.getName());
        }
        if (methodHostClass.isPrimitive()) {
            throw new IllegalArgumentException("methodHostClass.isPrimitive(): " + methodHostClass.getName());
        }
        ExecutableBasedConverter returnValue = null;
        Method temp = null;
        try {
            temp = methodHostClass.getMethod(methodName, soleParameterType);
        }
        catch (NoSuchMethodException noSuchMethodException) {
        }
        finally {
            method = temp;
        }
        if (method != null && Modifier.isStatic(method.getModifiers()) && methodHostClass.isAssignableFrom(method.getReturnType())) {
            returnValue = new ExecutableBasedConverter(method);
        }
        return returnValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final <T> Converter<T> getConverterFromConstructor(Class<T> constructorHostClass, Class<? extends CharSequence> soleParameterType) {
        Constructor<T> constructor;
        Objects.requireNonNull(constructorHostClass);
        Objects.requireNonNull(soleParameterType);
        if (constructorHostClass.isPrimitive()) {
            throw new IllegalArgumentException("constructorHostClass.isPrimitive(): " + constructorHostClass.getName());
        }
        if (constructorHostClass.isArray()) {
            throw new IllegalArgumentException("constructorHostClass.isArray(): " + constructorHostClass.getName());
        }
        ExecutableBasedConverter returnValue = null;
        Constructor<T> temp = null;
        try {
            temp = constructorHostClass.getConstructor(soleParameterType);
        }
        catch (NoSuchMethodException noSuchMethodException) {
        }
        finally {
            constructor = temp;
        }
        if (constructor != null) {
            returnValue = new ExecutableBasedConverter(constructor);
        }
        return returnValue;
    }

    static final String[] split(String text) {
        String[] returnValue;
        if (text == null) {
            returnValue = new String[]{};
        } else {
            returnValue = splitPattern.split(text);
            assert (returnValue != null);
            for (int i = 0; i < returnValue.length; ++i) {
                returnValue[i] = backslashCommaPattern.matcher(returnValue[i]).replaceAll(",");
            }
        }
        return returnValue;
    }

    static final Map<? extends Type, ? extends Converter<?>> getDiscoveredConverters(ClassLoader classLoader) {
        if (classLoader == null) {
            classLoader = AccessController.doPrivileged(() -> Thread.currentThread().getContextClassLoader());
        }
        HashMap<Type, Converter> converters = new HashMap<Type, Converter>();
        ServiceLoader<Converter> discoveredConverters = ServiceLoader.load(Converter.class, classLoader);
        assert (discoveredConverters != null);
        for (Converter discoveredConverter : discoveredConverters) {
            if (discoveredConverter == null) continue;
            Type conversionType = Converters.getConversionType(discoveredConverter);
            if (conversionType == null) {
                throw new IllegalStateException("Could not determine the conversion type for converter: " + discoveredConverter);
            }
            converters.put(conversionType, discoveredConverter);
        }
        return Collections.unmodifiableMap(converters);
    }

    static {
        wrapperClasses.put(Boolean.TYPE, Boolean.class);
        wrapperClasses.put(Byte.TYPE, Byte.class);
        wrapperClasses.put(Character.TYPE, Character.class);
        wrapperClasses.put(Double.TYPE, Double.class);
        wrapperClasses.put(Float.TYPE, Float.class);
        wrapperClasses.put(Integer.TYPE, Integer.class);
        wrapperClasses.put(Long.TYPE, Long.class);
        wrapperClasses.put(Short.TYPE, Short.class);
    }

    private static final class PropertyEditorConverter<T>
    extends SerializableConverter<T> {
        private static final long serialVersionUID = 1L;
        private final Class<?> conversionClass;
        private transient PropertyEditor editor;

        private PropertyEditorConverter(Class<?> conversionClass, PropertyEditor editor) {
            this.conversionClass = Objects.requireNonNull(conversionClass);
            this.editor = editor == null ? PropertyEditorManager.findEditor(conversionClass) : editor;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final T convert(String rawValue) {
            Object returnValue;
            if (this.editor == null) {
                throw new IllegalArgumentException("No PropertyEditor available to convert " + rawValue);
            }
            PropertyEditor propertyEditor = this.editor;
            synchronized (propertyEditor) {
                this.editor.setAsText(rawValue);
                Object result = null;
                try {
                    Object temp;
                    result = temp = this.editor.getValue();
                }
                catch (ClassCastException classCastException) {
                    throw new IllegalArgumentException(classCastException.getMessage(), classCastException);
                }
                finally {
                    Object returnValue2 = result;
                }
            }
            return (T)returnValue;
        }

        private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
            if (in != null) {
                in.defaultReadObject();
                this.editor = PropertyEditorManager.findEditor(this.conversionClass);
            }
        }
    }

    private static final class ExecutableBasedConverter<T>
    extends SerializableConverter<T> {
        private static final long serialVersionUID = 1L;
        private transient Executable executable;

        private ExecutableBasedConverter(Method method) {
            this.executable = Objects.requireNonNull(method);
            if (!Modifier.isStatic(method.getModifiers())) {
                throw new IllegalArgumentException("method is not static: " + method);
            }
        }

        private ExecutableBasedConverter(Constructor<T> constructor) {
            this.executable = Objects.requireNonNull(constructor);
        }

        public final T convert(String rawValue) {
            Object returnValue;
            if (rawValue == null) {
                returnValue = null;
            } else {
                Object convertedObject = null;
                try {
                    if (this.executable instanceof Method) {
                        Object invocationResult;
                        convertedObject = invocationResult = ((Method)this.executable).invoke(null, rawValue);
                    } else {
                        assert (this.executable instanceof Constructor);
                        Object invocationResult = ((Constructor)this.executable).newInstance(rawValue);
                        convertedObject = invocationResult;
                    }
                }
                catch (ReflectiveOperationException reflectiveOperationException) {
                    throw new IllegalArgumentException(reflectiveOperationException.getMessage(), reflectiveOperationException);
                }
                finally {
                    Object returnValue2 = convertedObject;
                }
            }
            return (T)returnValue;
        }

        private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
            if (in != null) {
                String methodName;
                in.defaultReadObject();
                boolean constructor = in.readBoolean();
                Class declaringClass = (Class)in.readObject();
                assert (declaringClass != null);
                if (constructor) {
                    methodName = null;
                } else {
                    methodName = in.readUTF();
                    assert (methodName != null);
                }
                Class[] parameterTypes = (Class[])in.readObject();
                assert (parameterTypes != null);
                try {
                    this.executable = constructor ? declaringClass.getDeclaredConstructor(parameterTypes) : declaringClass.getMethod(methodName, parameterTypes);
                }
                catch (ReflectiveOperationException reflectiveOperationException) {
                    throw new IOException(reflectiveOperationException.getMessage(), reflectiveOperationException);
                }
                assert (this.executable != null);
            }
        }

        private void writeObject(ObjectOutputStream out) throws IOException {
            if (out != null) {
                out.defaultWriteObject();
                assert (this.executable != null);
                boolean constructor = this.executable instanceof Constructor;
                out.writeBoolean(constructor);
                out.writeObject(this.executable.getDeclaringClass());
                if (!constructor) {
                    out.writeUTF(this.executable.getName());
                }
                out.writeObject(this.executable.getParameterTypes());
            }
        }
    }

    private static abstract class SerializableConverter<T>
    implements Converter<T>,
    Serializable {
        private static final long serialVersionUID = 1L;

        protected SerializableConverter() {
        }
    }
}

