/*
 * Decompiled with CFR 0.152.
 */
package org.microbean.microprofile.config;

import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.security.AccessController;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Set;
import java.util.WeakHashMap;
import org.eclipse.microprofile.config.Config;
import org.microbean.microprofile.config.ConfigBuilder;

public final class ConfigProviderResolver
extends org.eclipse.microprofile.config.spi.ConfigProviderResolver
implements AutoCloseable {
    private final WeakHashMap<ClassLoader, WeakAutoCloseableReference<ClassLoader, Config>> configMap = new WeakHashMap();
    private final ReferenceQueue<? super ClassLoader> autoClosingReferenceQueue = new ReferenceQueue();

    public ConfigProviderResolver() {
        AutoCloseableCloserThread cleaner = new AutoCloseableCloserThread(this.autoClosingReferenceQueue);
        cleaner.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void close() {
        WeakHashMap<ClassLoader, WeakAutoCloseableReference<ClassLoader, Config>> weakHashMap = this.configMap;
        synchronized (weakHashMap) {
            HashSet<WeakAutoCloseableReference<ClassLoader, Config>> configsSnapshot;
            if (!this.configMap.isEmpty() && !(configsSnapshot = new HashSet<WeakAutoCloseableReference<ClassLoader, Config>>(this.configMap.values())).isEmpty()) {
                RuntimeException throwMe = null;
                for (WeakAutoCloseableReference weakAutoCloseableReference : configsSnapshot) {
                    assert (weakAutoCloseableReference != null);
                    Config config = (Config)weakAutoCloseableReference.getPotentialAutoCloseable();
                    if (config == null) continue;
                    try {
                        this.releaseConfig(config);
                    }
                    catch (RuntimeException runtimeException) {
                        if (throwMe == null) {
                            throwMe = runtimeException;
                            continue;
                        }
                        throwMe.addSuppressed(runtimeException);
                    }
                    catch (Exception exception) {
                        if (throwMe == null) {
                            throwMe = new RuntimeException(exception);
                            continue;
                        }
                        throwMe.addSuppressed(exception);
                    }
                }
                if (throwMe != null) {
                    throw throwMe;
                }
            }
        }
    }

    public final org.eclipse.microprofile.config.spi.ConfigBuilder getBuilder() {
        return new ConfigBuilder();
    }

    public final Config getConfig() {
        return this.getConfig(AccessController.doPrivileged(() -> Thread.currentThread().getContextClassLoader()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final Config getConfig(ClassLoader classLoader) {
        if (classLoader == null) {
            classLoader = AccessController.doPrivileged(() -> Thread.currentThread().getContextClassLoader());
        }
        Config returnValue = null;
        WeakHashMap<ClassLoader, WeakAutoCloseableReference<ClassLoader, Config>> weakHashMap = this.configMap;
        synchronized (weakHashMap) {
            WeakAutoCloseableReference<ClassLoader, Config> configReference = this.configMap.get(classLoader);
            if (configReference != null) {
                returnValue = (Config)((WeakAutoCloseableReference)configReference).getPotentialAutoCloseable();
            }
            if (returnValue == null) {
                returnValue = this.getBuilder().addDefaultSources().addDiscoveredSources().addDiscoveredConverters().forClassLoader(classLoader).build();
                assert (returnValue != null);
                this.registerConfig(returnValue, classLoader);
            }
        }
        return returnValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void registerConfig(Config config, ClassLoader classLoader) {
        if (config != null) {
            if (classLoader == null) {
                classLoader = AccessController.doPrivileged(() -> Thread.currentThread().getContextClassLoader());
            }
            WeakAutoCloseableReference configReference = new WeakAutoCloseableReference(classLoader, config, this.autoClosingReferenceQueue);
            WeakHashMap<ClassLoader, WeakAutoCloseableReference<ClassLoader, Config>> weakHashMap = this.configMap;
            synchronized (weakHashMap) {
                Config oldConfig;
                WeakAutoCloseableReference oldConfigReference = this.configMap.putIfAbsent(classLoader, configReference);
                if (oldConfigReference != null && (oldConfig = (Config)oldConfigReference.getPotentialAutoCloseable()) != null) {
                    throw new IllegalStateException("configMap.containsKey(" + classLoader + "): " + oldConfig);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void releaseConfig(Config config) {
        if (config != null) {
            RuntimeException throwMe = null;
            WeakHashMap<ClassLoader, WeakAutoCloseableReference<ClassLoader, Config>> weakHashMap = this.configMap;
            synchronized (weakHashMap) {
                Iterator entryIterator;
                Set<Map.Entry<ClassLoader, WeakAutoCloseableReference<ClassLoader, Config>>> entrySet;
                if (!this.configMap.isEmpty() && (entrySet = this.configMap.entrySet()) != null && !entrySet.isEmpty() && (entryIterator = entrySet.iterator()) != null) {
                    while (entryIterator.hasNext()) {
                        Config existingConfig;
                        WeakAutoCloseableReference configReference;
                        Map.Entry entry = null;
                        try {
                            entry = (Map.Entry)entryIterator.next();
                        }
                        catch (NoSuchElementException noSuchElementException) {
                            // empty catch block
                        }
                        if (entry == null || (configReference = (WeakAutoCloseableReference)entry.getValue()) == null || !config.equals(existingConfig = (Config)configReference.getPotentialAutoCloseable())) continue;
                        try {
                            entryIterator.remove();
                        }
                        catch (RuntimeException runtimeException) {
                            if (throwMe == null) {
                                throwMe = runtimeException;
                            }
                            throwMe.addSuppressed(runtimeException);
                        }
                        if (!(existingConfig instanceof AutoCloseable)) continue;
                        try {
                            ((AutoCloseable)existingConfig).close();
                        }
                        catch (RuntimeException runtimeException) {
                            if (throwMe == null) {
                                throwMe = runtimeException;
                                continue;
                            }
                            throwMe.addSuppressed(runtimeException);
                        }
                        catch (InterruptedException interruptedException) {
                            Thread.currentThread().interrupt();
                        }
                        catch (Exception exception) {
                            if (throwMe == null) {
                                throwMe = new RuntimeException(exception.getMessage(), exception);
                                continue;
                            }
                            throwMe.addSuppressed(exception);
                        }
                    }
                }
            }
            if (throwMe != null) {
                throw throwMe;
            }
        }
    }

    private static final class AutoCloseableCloserThread
    extends Thread {
        private final ReferenceQueue<?> referenceQueue;

        private AutoCloseableCloserThread(ReferenceQueue<?> referenceQueue) {
            super(AutoCloseableCloserThread.class.getName());
            this.setDaemon(true);
            this.setPriority(2);
            this.referenceQueue = Objects.requireNonNull(referenceQueue);
        }

        @Override
        public final void run() {
            while (!this.isInterrupted()) {
                try {
                    Reference<?> reference = this.referenceQueue.remove();
                    if (!(reference instanceof AutoCloseable)) continue;
                    try {
                        ((AutoCloseable)((Object)reference)).close();
                    }
                    catch (InterruptedException interruptedException) {
                        this.interrupt();
                    }
                    catch (RuntimeException throwMe) {
                        throw throwMe;
                    }
                    catch (Exception exception) {
                        throw new RuntimeException(exception.getMessage(), exception);
                    }
                }
                catch (InterruptedException interruptedException) {
                    this.interrupt();
                }
                catch (RuntimeException throwMe) {
                    throw throwMe;
                }
                catch (Exception exception) {
                    throw new RuntimeException(exception.getMessage(), exception);
                }
            }
        }
    }

    private static final class WeakAutoCloseableReference<R, A>
    extends WeakReference<R>
    implements AutoCloseable {
        private final A potentialAutoCloseable;

        private WeakAutoCloseableReference(R referent, A potentialAutoCloseable, ReferenceQueue<? super R> referenceQueue) {
            super(referent, Objects.requireNonNull(referenceQueue));
            this.potentialAutoCloseable = potentialAutoCloseable;
        }

        private final A getPotentialAutoCloseable() {
            return this.potentialAutoCloseable;
        }

        @Override
        public final void close() throws Exception {
            A potentialAutoCloseable = this.getPotentialAutoCloseable();
            if (potentialAutoCloseable instanceof AutoCloseable) {
                ((AutoCloseable)potentialAutoCloseable).close();
            }
        }
    }
}

