/*
 * Decompiled with CFR 0.152.
 */
package org.microbean.microprofile.config;

import java.io.IOException;
import java.lang.reflect.Type;
import java.security.AccessController;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import org.eclipse.microprofile.config.spi.ConfigSource;
import org.eclipse.microprofile.config.spi.Converter;
import org.microbean.microprofile.config.Config;
import org.microbean.microprofile.config.ConfigSourceComparator;
import org.microbean.microprofile.config.ConversionHub;
import org.microbean.microprofile.config.Converters;
import org.microbean.microprofile.config.PrioritizedConverter;

class ConfigBuilder
implements org.eclipse.microprofile.config.spi.ConfigBuilder {
    private volatile boolean addDefaultSources;
    private volatile boolean addDiscoveredSources;
    private volatile boolean addDiscoveredConverters;
    private final Collection<Converter<?>> converters = new LinkedList();
    private final Collection<ConfigSource> sources = new LinkedList<ConfigSource>();
    private volatile ClassLoader classLoader = AccessController.doPrivileged(() -> Thread.currentThread().getContextClassLoader());

    ConfigBuilder() {
    }

    public final ConfigBuilder addDefaultSources() {
        this.addDefaultSources = true;
        return this;
    }

    public final ConfigBuilder addDiscoveredSources() {
        this.addDiscoveredSources = true;
        return this;
    }

    public final ConfigBuilder addDiscoveredConverters() {
        this.addDiscoveredConverters = true;
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final org.eclipse.microprofile.config.Config build() {
        Collection<ConfigSource> defaultConfigSources;
        LinkedList<Object> sources = null;
        ClassLoader classLoader = null;
        if (this.addDefaultSources) {
            classLoader = this.classLoader;
            sources = new LinkedList<Object>();
            defaultConfigSources = null;
            try {
                defaultConfigSources = Config.getDefaultConfigSources(classLoader);
            }
            catch (IOException ioException) {
                throw new RuntimeException(ioException.getMessage(), ioException);
            }
            assert (defaultConfigSources != null);
            sources.addAll(defaultConfigSources);
        }
        if (this.addDiscoveredSources) {
            if (classLoader == null) {
                classLoader = this.classLoader;
            }
            if (sources == null) {
                sources = new LinkedList();
            }
            sources.addAll(Config.getDiscoveredConfigSources(classLoader));
        }
        defaultConfigSources = this.sources;
        synchronized (defaultConfigSources) {
            if (!this.sources.isEmpty()) {
                if (sources == null) {
                    sources = new LinkedList();
                }
                sources.addAll(this.sources);
            }
        }
        if (sources != null) {
            Collections.sort(sources, ConfigSourceComparator.INSTANCE);
        }
        HashMap<? extends Type, Object> converters = new HashMap<Type, Object>();
        if (this.addDiscoveredConverters) {
            if (classLoader == null) {
                classLoader = this.classLoader;
            }
            converters.putAll(ConversionHub.getDiscoveredConverters(classLoader));
        }
        Collection<Converter<?>> collection = this.converters;
        synchronized (collection) {
            if (!this.converters.isEmpty()) {
                for (Converter<?> converter : this.converters) {
                    Converter existingConverter;
                    int oldPriority;
                    assert (converter != null);
                    Type conversionType = Converters.getConversionType(converter);
                    if (conversionType == null) {
                        throw new IllegalStateException("Could not determine the conversion type for converter: " + converter);
                    }
                    int priority = Converters.getPriority(converter);
                    if (priority <= (oldPriority = (existingConverter = (Converter)converters.get(conversionType)) == null ? Integer.MIN_VALUE : Converters.getPriority(existingConverter))) continue;
                    converters.put(conversionType, converter);
                }
            }
        }
        return new Config(sources, new ConversionHub(converters));
    }

    public final <T> ConfigBuilder withConverter(Class<T> type, int ordinal, Converter<T> converter) {
        return this.withConverter((Type)type, ordinal, converter);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final <T> ConfigBuilder withConverter(Type type, int ordinal, Converter<T> converter) {
        if (type != null && converter != null) {
            Collection<Converter<?>> collection = this.converters;
            synchronized (collection) {
                this.converters.add(new PrioritizedConverter<T>(converter, type, ordinal));
            }
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final ConfigBuilder withConverters(Converter<?> ... converters) {
        if (converters != null) {
            Collection<Converter<?>> collection = this.converters;
            synchronized (collection) {
                if (converters.length > 0) {
                    for (Converter<?> converter : converters) {
                        if (converter == null) continue;
                        this.converters.add(converter);
                    }
                }
            }
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final ConfigBuilder withSources(ConfigSource ... sources) {
        if (sources != null) {
            Collection<ConfigSource> collection = this.sources;
            synchronized (collection) {
                for (ConfigSource configSource : sources) {
                    if (configSource == null) continue;
                    this.sources.add(configSource);
                }
            }
        }
        return this;
    }

    public final ConfigBuilder forClassLoader(ClassLoader classLoader) {
        this.classLoader = classLoader == null ? AccessController.doPrivileged(() -> Thread.currentThread().getContextClassLoader()) : classLoader;
        return this;
    }
}

