/*
 * Decompiled with CFR 0.152.
 */
package org.microbean.microprofile.config;

import java.io.BufferedReader;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Serializable;
import java.lang.reflect.Type;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.security.AccessController;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.LinkedList;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Optional;
import java.util.Properties;
import java.util.ServiceLoader;
import java.util.Set;
import java.util.TreeSet;
import org.eclipse.microprofile.config.spi.ConfigSource;
import org.eclipse.microprofile.config.spi.ConfigSourceProvider;
import org.microbean.microprofile.config.ConfigProviderResolver;
import org.microbean.microprofile.config.ConfigSourceComparator;
import org.microbean.microprofile.config.ConversionHub;
import org.microbean.microprofile.config.EnvironmentVariablesConfigSource;
import org.microbean.microprofile.config.PropertiesConfigSource;
import org.microbean.microprofile.config.SystemPropertiesConfigSource;
import org.microbean.microprofile.config.TypeConverter;

public final class Config
implements Closeable,
org.eclipse.microprofile.config.Config,
Serializable,
TypeConverter {
    private static final long serialVersionUID = 1L;
    private final TypeConverter typeConverter;
    private final Collection<ConfigSource> sources;
    private volatile boolean closed;

    public Config() throws IOException {
        LinkedList<Object> sources = new LinkedList<Object>();
        Collection<? extends ConfigSource> defaultConfigSources = Config.getDefaultConfigSources();
        Collection<? extends ConfigSource> discoveredConfigSources = Config.getDiscoveredConfigSources(null);
        sources.addAll(defaultConfigSources);
        sources.addAll(discoveredConfigSources);
        Collections.sort(sources, ConfigSourceComparator.INSTANCE);
        this.sources = Collections.unmodifiableCollection(sources);
        this.typeConverter = new ConversionHub();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Config(Collection<? extends ConfigSource> sources, TypeConverter typeConverter) {
        this.typeConverter = Objects.requireNonNull(typeConverter);
        if (sources == null) {
            this.sources = Collections.emptySet();
        } else {
            Collection<? extends ConfigSource> collection = sources;
            synchronized (collection) {
                this.sources = sources.isEmpty() ? Collections.emptySet() : Collections.unmodifiableCollection(sources);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void close() throws IOException {
        boolean oldClosed = this.isClosed();
        if (!oldClosed) {
            IOException throwMe = null;
            Collection<ConfigSource> collection = this.sources;
            synchronized (collection) {
                for (ConfigSource configSource : this.sources) {
                    if (!(configSource instanceof Closeable)) continue;
                    try {
                        ((Closeable)configSource).close();
                    }
                    catch (IOException ioException) {
                        if (throwMe == null) {
                            throwMe = ioException;
                            continue;
                        }
                        throwMe.addSuppressed(ioException);
                    }
                }
            }
            if (this.typeConverter instanceof Closeable) {
                try {
                    ((Closeable)((Object)this.typeConverter)).close();
                }
                catch (IOException ioException) {
                    if (throwMe == null) {
                        throwMe = ioException;
                    }
                    throwMe.addSuppressed(ioException);
                }
            }
            if (throwMe != null) {
                throw throwMe;
            }
            this.closed = true;
            ConfigProviderResolver.instance().releaseConfig((org.eclipse.microprofile.config.Config)this);
        }
    }

    public final boolean isClosed() {
        return this.closed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final Iterable<ConfigSource> getConfigSources() {
        Collection<ConfigSource> returnValue;
        if (this.isClosed()) {
            throw new IllegalStateException("this.isClosed()");
        }
        Collection<ConfigSource> collection = this.sources;
        synchronized (collection) {
            returnValue = this.sources.isEmpty() ? Collections.emptySet() : Collections.unmodifiableCollection(new ArrayList<ConfigSource>(this.sources));
        }
        return returnValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final Iterable<String> getPropertyNames() {
        Set<String> returnValue;
        Iterable<ConfigSource> configSources = this.getConfigSources();
        if (configSources == null) {
            returnValue = Collections.emptySet();
        } else {
            TreeSet names = new TreeSet();
            for (ConfigSource configSource : configSources) {
                if (configSource == null) continue;
                ConfigSource configSource2 = configSource;
                synchronized (configSource2) {
                    Set sourceNames = configSource.getPropertyNames();
                    if (sourceNames != null && !sourceNames.isEmpty()) {
                        names.addAll(sourceNames);
                    }
                }
            }
            returnValue = Collections.unmodifiableSet(names);
        }
        assert (returnValue != null);
        return returnValue;
    }

    public final <T> Optional<T> getOptionalValue(String name, Class<T> type) {
        return this.getOptionalValue(name, (Type)type);
    }

    public final <T> Optional<T> getOptionalValue(String name, Type type) {
        Objects.requireNonNull(type);
        Optional returnValue = null;
        Iterable<ConfigSource> configSources = this.getConfigSources();
        if (configSources != null) {
            for (ConfigSource configSource : configSources) {
                String value;
                if (configSource == null || (value = configSource.getValue(name)) == null) continue;
                returnValue = Optional.of(this.convert(value, type));
                assert (returnValue != null);
                if (!returnValue.isPresent()) continue;
                break;
            }
        }
        if (returnValue == null) {
            returnValue = Optional.empty();
        }
        return returnValue;
    }

    public final <T> T getValue(String name, Class<T> type) {
        return this.getValue(name, (Type)type);
    }

    public final <T> T getValue(String name, Type type) {
        Objects.requireNonNull(type);
        T returnValue = null;
        Iterable<ConfigSource> configSources = this.getConfigSources();
        if (configSources != null) {
            for (ConfigSource configSource : configSources) {
                String value;
                if (configSource != null && (value = configSource.getValue(name)) != null && (returnValue = (T)this.convert(value, type)) != null) break;
            }
        }
        if (returnValue == null) {
            throw new NoSuchElementException(name);
        }
        return returnValue;
    }

    @Override
    public final <T> T convert(String rawValue, Type type) {
        if (this.isClosed()) {
            throw new IllegalStateException("this.isClosed()");
        }
        return this.typeConverter.convert(rawValue, type);
    }

    static final Collection<? extends ConfigSource> getDefaultConfigSources() throws IOException {
        return Config.getDefaultConfigSources(null);
    }

    static final Collection<? extends ConfigSource> getDefaultConfigSources(ClassLoader classLoader) throws IOException {
        LinkedList<? extends ConfigSource> sources = new LinkedList<ConfigSource>();
        sources.add(new SystemPropertiesConfigSource());
        sources.add(new EnvironmentVariablesConfigSource());
        Collection<? extends ConfigSource> microprofileConfigPropertiesConfigSources = Config.getMicroprofileConfigPropertiesSources(classLoader);
        if (microprofileConfigPropertiesConfigSources != null && !microprofileConfigPropertiesConfigSources.isEmpty()) {
            sources.addAll(microprofileConfigPropertiesConfigSources);
        }
        return Collections.unmodifiableCollection(sources);
    }

    static final Collection<? extends ConfigSource> getMicroprofileConfigPropertiesSources(ClassLoader classLoader) throws IOException {
        if (classLoader == null) {
            classLoader = AccessController.doPrivileged(() -> Thread.currentThread().getContextClassLoader());
        }
        Enumeration<URL> urls = classLoader.getResources("META-INF/microprofile-config.properties");
        Collection<Object> returnValue = new ArrayList();
        if (urls != null) {
            while (urls.hasMoreElements()) {
                URL url = urls.nextElement();
                if (url == null) continue;
                Properties properties = new Properties();
                try (BufferedReader reader = new BufferedReader(new InputStreamReader(url.openStream(), StandardCharsets.ISO_8859_1));){
                    properties.load(reader);
                }
                returnValue.add(new PropertiesConfigSource(properties, url.toString()));
            }
        }
        returnValue = returnValue.isEmpty() ? Collections.emptySet() : Collections.unmodifiableCollection(returnValue);
        return returnValue;
    }

    static final Collection<? extends ConfigSource> getDiscoveredConfigSources(ClassLoader classLoader) {
        if (classLoader == null) {
            classLoader = AccessController.doPrivileged(() -> Thread.currentThread().getContextClassLoader());
        }
        ServiceLoader<ConfigSource> discoveredSources = ServiceLoader.load(ConfigSource.class, classLoader);
        assert (discoveredSources != null);
        LinkedList<ConfigSource> sources = new LinkedList<ConfigSource>();
        for (ConfigSource source : discoveredSources) {
            if (source == null) continue;
            sources.add(source);
        }
        ServiceLoader<ConfigSourceProvider> discoveredConfigSourceProviders = ServiceLoader.load(ConfigSourceProvider.class, classLoader);
        assert (discoveredConfigSourceProviders != null);
        for (ConfigSourceProvider provider : discoveredConfigSourceProviders) {
            Iterable configSources;
            if (provider == null || (configSources = provider.getConfigSources(classLoader)) == null) continue;
            for (ConfigSource configSource : configSources) {
                if (configSource == null) continue;
                sources.add(configSource);
            }
        }
        return Collections.unmodifiableCollection(sources);
    }
}

