/*
 * Decompiled with CFR 0.152.
 */
package org.microbean.constant;

import java.lang.constant.ClassDesc;
import java.lang.constant.Constable;
import java.lang.constant.ConstantDesc;
import java.lang.constant.DirectMethodHandleDesc;
import java.lang.constant.DynamicConstantDesc;
import java.lang.constant.MethodHandleDesc;
import java.lang.constant.MethodTypeDesc;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.function.Function;
import org.microbean.constant.ConstantDescs;

public final class Constables {
    private static final ClassDesc CD_BootstrapMethods = ClassDesc.of("org.microbean.invoke.BootstrapMethods");
    private static final ConstantDesc[] EMPTY_CONSTANTDESC_ARRAY = new ConstantDesc[0];

    private Constables() {
    }

    public static final Optional<? extends ConstantDesc> describeConstable(Object o) {
        Optional<ConstantDesc> optional;
        if (o == null) {
            optional = Optional.of(java.lang.constant.ConstantDescs.NULL);
        } else if (o instanceof Constable) {
            Constable c = (Constable)o;
            optional = c.describeConstable();
        } else if (o instanceof ConstantDesc) {
            ConstantDesc cd = (ConstantDesc)o;
            optional = Optional.of(cd);
        } else if (o instanceof List) {
            List l = (List)o;
            optional = Constables.describeConstable(l);
        } else if (o instanceof Set) {
            Set s = (Set)o;
            optional = Constables.describeConstable(s);
        } else if (o instanceof Map) {
            Map m = (Map)o;
            optional = Constables.describeConstable(m);
        } else if (o instanceof Map.Entry) {
            Map.Entry e = (Map.Entry)o;
            optional = Constables.describeConstable(e);
        } else if (o instanceof Optional) {
            Optional opt = (Optional)o;
            optional = Constables.describeConstable(opt);
        } else {
            optional = Optional.empty();
        }
        return optional;
    }

    public static final Optional<? extends ConstantDesc> describeConstable(Optional<?> o) {
        return Constables.describeConstable(o, Constables::describeConstable);
    }

    public static final <T> Optional<? extends ConstantDesc> describeConstable(Optional<? extends T> o, Function<? super T, ? extends Optional<? extends ConstantDesc>> f) {
        Optional<? extends ConstantDesc> payload;
        if (o == null) {
            return Optional.of(java.lang.constant.ConstantDescs.NULL);
        }
        if (o.isEmpty()) {
            return Optional.of(Constables.callStatic(ConstantDescs.CD_Optional, "empty", MethodTypeDesc.of(ConstantDescs.CD_Optional, new ClassDesc[0]), new ConstantDesc[0]));
        }
        Optional<? extends ConstantDesc> optional = payload = f == null ? Constables.describeConstable(o.orElseThrow()) : f.apply(o.orElseThrow());
        if (payload.isEmpty()) {
            return Optional.empty();
        }
        return Optional.of(Constables.callStatic(ConstantDescs.CD_Optional, "ofNullable", MethodTypeDesc.of(ConstantDescs.CD_Optional, java.lang.constant.ConstantDescs.CD_Object), payload.orElseThrow()));
    }

    public static final Optional<? extends ConstantDesc> describeConstable(ConstantDesc cd) {
        Optional<ConstantDesc> optional;
        if (cd == null) {
            optional = Optional.of(java.lang.constant.ConstantDescs.NULL);
        } else if (cd instanceof Constable) {
            Constable c = (Constable)((Object)cd);
            optional = c.describeConstable();
        } else {
            optional = Optional.of(cd);
        }
        return optional;
    }

    public static final Optional<? extends ConstantDesc> describeConstable(Constable c) {
        return c == null ? Optional.of(java.lang.constant.ConstantDescs.NULL) : c.describeConstable();
    }

    public static final Optional<? extends ConstantDesc> describeConstable(Collection<?> elements) {
        return Constables.describeConstable(elements, Constables::empty, Constables::describeConstable);
    }

    public static final <E> Optional<? extends ConstantDesc> describeConstable(Collection<? extends E> elements, Function<? super E, ? extends Optional<? extends ConstantDesc>> f) {
        return Constables.describeConstable(elements, Constables::empty, f);
    }

    public static final <E> Optional<? extends ConstantDesc> describeConstable(Collection<? extends E> elements, Function<? super Comparator<?>, ? extends Optional<? extends ConstantDesc>> cf, Function<? super E, ? extends Optional<? extends ConstantDesc>> f) {
        Optional<ConstantDesc> optional;
        if (elements == null) {
            optional = Optional.of(java.lang.constant.ConstantDescs.NULL);
        } else if (elements instanceof List) {
            List l = (List)elements;
            optional = Constables.describeConstable0(l, java.lang.constant.ConstantDescs.CD_List, cf, f);
        } else if (elements instanceof Set) {
            Set s = (Set)elements;
            optional = Constables.describeConstable0(s, java.lang.constant.ConstantDescs.CD_Set, cf, f);
        } else {
            optional = Optional.empty();
        }
        return optional;
    }

    public static final Optional<? extends ConstantDesc> describeConstable(List<?> elements) {
        return Constables.describeConstable0(elements, java.lang.constant.ConstantDescs.CD_List, Constables::empty, Constables::describeConstable);
    }

    public static final <E> Optional<? extends ConstantDesc> describeConstable(List<? extends E> elements, Function<? super E, ? extends Optional<? extends ConstantDesc>> f) {
        return Constables.describeConstable0(elements, java.lang.constant.ConstantDescs.CD_List, Constables::empty, f);
    }

    public static final Optional<? extends ConstantDesc> describeConstable(Set<?> elements) {
        return Constables.describeConstable0(elements, java.lang.constant.ConstantDescs.CD_Set, Constables::empty, Constables::describeConstable);
    }

    public static final <E> Optional<? extends ConstantDesc> describeConstable(Set<? extends E> elements, Function<? super E, ? extends Optional<? extends ConstantDesc>> f) {
        return Constables.describeConstable0(elements, java.lang.constant.ConstantDescs.CD_Set, Constables::empty, f);
    }

    public static final <E> Optional<? extends ConstantDesc> describeConstable(Set<? extends E> elements, Function<? super Comparator<?>, ? extends Optional<? extends ConstantDesc>> cf, Function<? super E, ? extends Optional<? extends ConstantDesc>> f) {
        return Constables.describeConstable0(elements, java.lang.constant.ConstantDescs.CD_Set, cf, f);
    }

    public static final Optional<? extends ConstantDesc> describeConstable(Map<?, ?> map) {
        return Constables.describeConstable0(map, Constables::empty, Constables::describeConstable, Constables::describeConstable);
    }

    public static final <K, V> Optional<? extends ConstantDesc> describeConstable(Map<? extends K, ? extends V> map, Function<? super K, ? extends Optional<? extends ConstantDesc>> kf, Function<? super V, ? extends Optional<? extends ConstantDesc>> vf) {
        return Constables.describeConstable0(map, Constables::empty, kf, vf);
    }

    public static final <K, V> Optional<? extends ConstantDesc> describeConstable(Map<? extends K, ? extends V> map, Function<? super Comparator<?>, ? extends Optional<? extends ConstantDesc>> cf, Function<? super K, ? extends Optional<? extends ConstantDesc>> kf, Function<? super V, ? extends Optional<? extends ConstantDesc>> vf) {
        return Constables.describeConstable0(map, cf, kf, vf);
    }

    public static final Optional<? extends ConstantDesc> describeConstable(Map.Entry<?, ?> entry) {
        return Constables.describeConstable(entry, Constables::describeConstable, Constables::describeConstable);
    }

    public static final <K, V> Optional<? extends ConstantDesc> describeConstable(Map.Entry<? extends K, ? extends V> entry, Function<? super K, ? extends Optional<? extends ConstantDesc>> kf, Function<? super V, ? extends Optional<? extends ConstantDesc>> vf) {
        Optional<ConstantDesc> optional;
        if (entry == null) {
            optional = Optional.of(java.lang.constant.ConstantDescs.NULL);
        } else if (entry instanceof Constable) {
            Constable c = (Constable)((Object)entry);
            optional = c.describeConstable();
        } else {
            optional = Constables.describeConstable(entry.getKey(), entry.getValue(), kf, vf);
        }
        return optional;
    }

    public static final <K, V> Optional<? extends ConstantDesc> describeConstable(K k, V v, Function<? super K, ? extends Optional<? extends ConstantDesc>> kf, Function<? super V, ? extends Optional<? extends ConstantDesc>> vf) {
        Optional<? extends ConstantDesc> key;
        if (k instanceof Constable) {
            Constable c = (Constable)k;
            v0 = c.describeConstable();
        } else {
            v0 = key = kf == null ? Constables.describeConstable(k) : kf.apply(k);
        }
        if (key.isPresent()) {
            Optional<? extends ConstantDesc> value;
            if (v instanceof Constable) {
                Constable c = (Constable)v;
                v1 = c.describeConstable();
            } else {
                v1 = value = vf == null ? Constables.describeConstable(v) : vf.apply(v);
            }
            if (value.isPresent()) {
                ConstantDesc keyDesc = key.orElseThrow();
                ConstantDesc valueDesc = value.orElseThrow();
                if (keyDesc == java.lang.constant.ConstantDescs.NULL || valueDesc == java.lang.constant.ConstantDescs.NULL) {
                    return Optional.of(Constables.construct(ConstantDescs.CD_SimpleImmutableEntry, new ClassDesc[]{java.lang.constant.ConstantDescs.CD_Object, java.lang.constant.ConstantDescs.CD_Object}, keyDesc, valueDesc));
                }
                return Optional.of(Constables.callInterfaceStatic(java.lang.constant.ConstantDescs.CD_Map, "entry", MethodTypeDesc.of(ConstantDescs.CD_Entry, java.lang.constant.ConstantDescs.CD_Object, java.lang.constant.ConstantDescs.CD_Object), keyDesc, valueDesc));
            }
        }
        return Optional.empty();
    }

    private static final <E> Optional<? extends ConstantDesc> describeConstable0(SortedSet<? extends E> set, Function<? super Comparator<?>, ? extends Optional<? extends ConstantDesc>> cf, Function<? super E, ? extends Optional<? extends ConstantDesc>> f) {
        if (set == null) {
            return Optional.of(java.lang.constant.ConstantDescs.NULL);
        }
        if (set instanceof Constable) {
            Constable c = (Constable)((Object)set);
            return c.describeConstable();
        }
        ConstantDesc comparatorDesc = Constables.describeComparator(set.comparator(), cf);
        if (comparatorDesc == null) {
            return Optional.empty();
        }
        if (set.isEmpty()) {
            if (comparatorDesc == java.lang.constant.ConstantDescs.NULL) {
                return Optional.of(Constables.callStatic(ConstantDescs.CD_Collections, "emptySortedSet", MethodTypeDesc.of(ConstantDescs.CD_SortedSet, new ClassDesc[0]), new ConstantDesc[0]));
            }
            return Optional.of(Constables.callStatic(CD_BootstrapMethods, "immutableSortedSetOf", MethodTypeDesc.of(ConstantDescs.CD_SortedSet, ConstantDescs.CD_Comparator), comparatorDesc));
        }
        ConstantDesc[] args = Constables.elements(set, f);
        if (args.length <= 0) {
            return Optional.empty();
        }
        DynamicConstantDesc<?> unsortedListDesc = Constables.asList(args);
        if (comparatorDesc == java.lang.constant.ConstantDescs.NULL) {
            return Optional.of(Constables.callStatic(CD_BootstrapMethods, "immutableSortedSetOf", MethodTypeDesc.of(ConstantDescs.CD_SortedSet, java.lang.constant.ConstantDescs.CD_Collection), unsortedListDesc));
        }
        return Optional.of(Constables.callStatic(CD_BootstrapMethods, "immutableSortedSetOf", MethodTypeDesc.of(ConstantDescs.CD_SortedSet, java.lang.constant.ConstantDescs.CD_Collection, ConstantDescs.CD_Comparator), unsortedListDesc, comparatorDesc));
    }

    private static final <E> Optional<? extends ConstantDesc> describeConstable0(Collection<? extends E> elements, ClassDesc listOrSetClassDesc, Function<? super Comparator<?>, ? extends Optional<? extends ConstantDesc>> cf, Function<? super E, ? extends Optional<? extends ConstantDesc>> f) {
        MethodTypeDesc ofMethodTypeDesc;
        assert (java.lang.constant.ConstantDescs.CD_List.equals(listOrSetClassDesc) || java.lang.constant.ConstantDescs.CD_Set.equals(listOrSetClassDesc)) : String.valueOf(listOrSetClassDesc);
        if (elements == null) {
            return Optional.of(java.lang.constant.ConstantDescs.NULL);
        }
        if (elements instanceof Constable) {
            Constable c = (Constable)((Object)elements);
            return c.describeConstable();
        }
        if (elements instanceof SortedSet) {
            SortedSet ss = (SortedSet)elements;
            return Constables.describeConstable0(ss, cf, f);
        }
        if (elements.isEmpty()) {
            return Optional.of(Constables.callInterfaceStatic(listOrSetClassDesc, "of", listOrSetClassDesc));
        }
        if (f == null) {
            f = Constables::describeConstable;
        }
        int elementsSize = elements.size();
        ConstantDesc[] args = new ConstantDesc[elementsSize];
        boolean nulls = false;
        int i = 0;
        for (E element : elements) {
            Optional<ConstantDesc> arg;
            if (element instanceof Constable) {
                Constable c = (Constable)element;
                v0 = c.describeConstable();
            } else {
                v0 = arg = f.apply(element);
            }
            if (arg == null || arg.isEmpty()) {
                return Optional.empty();
            }
            if (element == null && !nulls) {
                nulls = true;
            }
            args[i++] = arg.orElseThrow();
        }
        if (nulls) {
            DynamicConstantDesc<?> cd = Constables.asList(args);
            if (java.lang.constant.ConstantDescs.CD_List.equals(listOrSetClassDesc)) {
                assert (elements instanceof List);
                return Optional.of(Constables.callStatic(ConstantDescs.CD_Collections, "unmodifiableList", MethodTypeDesc.of(java.lang.constant.ConstantDescs.CD_List, java.lang.constant.ConstantDescs.CD_List), cd));
            }
            assert (elements instanceof Set);
            return Optional.of(Constables.callStatic(ConstantDescs.CD_Collections, "unmodifiableSet", MethodTypeDesc.of(java.lang.constant.ConstantDescs.CD_Set, java.lang.constant.ConstantDescs.CD_Set), Constables.construct(ConstantDescs.CD_HashSet, new ClassDesc[]{java.lang.constant.ConstantDescs.CD_Collection}, cd)));
        }
        if (elementsSize <= 10) {
            Object[] parameterArray = new ClassDesc[elementsSize];
            Arrays.fill(parameterArray, java.lang.constant.ConstantDescs.CD_Object);
            ofMethodTypeDesc = MethodTypeDesc.of(listOrSetClassDesc, (ClassDesc[])parameterArray);
        } else {
            ofMethodTypeDesc = MethodTypeDesc.of(listOrSetClassDesc, java.lang.constant.ConstantDescs.CD_Object.arrayType());
        }
        return Optional.of(Constables.callInterfaceStatic(listOrSetClassDesc, "of", ofMethodTypeDesc, args));
    }

    private static final <K, V> Optional<? extends ConstantDesc> describeConstable0(SortedMap<? extends K, ? extends V> map, Function<? super Comparator<?>, ? extends Optional<? extends ConstantDesc>> cf, Function<? super K, ? extends Optional<? extends ConstantDesc>> kf, Function<? super V, ? extends Optional<? extends ConstantDesc>> vf) {
        if (map == null) {
            return Optional.of(java.lang.constant.ConstantDescs.NULL);
        }
        if (map instanceof Constable) {
            Constable c = (Constable)((Object)map);
            return c.describeConstable();
        }
        ConstantDesc comparatorDesc = Constables.describeComparator(map.comparator(), cf);
        if (comparatorDesc == null) {
            return Optional.empty();
        }
        if (map.isEmpty()) {
            if (comparatorDesc == java.lang.constant.ConstantDescs.NULL) {
                return Optional.of(Constables.callStatic(ConstantDescs.CD_Collections, "emptySortedMap", MethodTypeDesc.of(ConstantDescs.CD_SortedMap, new ClassDesc[0]), new ConstantDesc[0]));
            }
            return Optional.of(Constables.callStatic(CD_BootstrapMethods, "immutableEmptySortedMap", MethodTypeDesc.of(ConstantDescs.CD_SortedMap, ConstantDescs.CD_Comparator), comparatorDesc));
        }
        DynamicConstantDesc<?> entriesListDesc = Constables.asList(Constables.entries(map, kf, vf, false));
        if (comparatorDesc == java.lang.constant.ConstantDescs.NULL) {
            return Optional.of(Constables.callStatic(CD_BootstrapMethods, "immutableSortedMapOf", MethodTypeDesc.of(ConstantDescs.CD_SortedMap, java.lang.constant.ConstantDescs.CD_Collection), entriesListDesc));
        }
        return Optional.of(Constables.callStatic(CD_BootstrapMethods, "immutableSortedMapOf", MethodTypeDesc.of(ConstantDescs.CD_SortedMap, java.lang.constant.ConstantDescs.CD_Collection, ConstantDescs.CD_Comparator), entriesListDesc, comparatorDesc));
    }

    private static final <K, V> Optional<? extends ConstantDesc> describeConstable0(Map<? extends K, ? extends V> map, Function<? super Comparator<?>, ? extends Optional<? extends ConstantDesc>> cf, Function<? super K, ? extends Optional<? extends ConstantDesc>> kf, Function<? super V, ? extends Optional<? extends ConstantDesc>> vf) {
        if (map == null) {
            return Optional.of(java.lang.constant.ConstantDescs.NULL);
        }
        if (map instanceof Constable) {
            Constable c = (Constable)((Object)map);
            return c.describeConstable();
        }
        if (map instanceof SortedMap) {
            SortedMap sm = (SortedMap)map;
            return Constables.describeConstable0(sm, cf, kf, vf);
        }
        if (map.isEmpty()) {
            return Optional.of(Constables.callInterfaceStatic(java.lang.constant.ConstantDescs.CD_Map, "of", java.lang.constant.ConstantDescs.CD_Map));
        }
        ConstantDesc[] args = Constables.entries(map, kf, vf, true);
        if (args.length <= 0) {
            return Optional.empty();
        }
        return Optional.of(Constables.callInterfaceStatic(java.lang.constant.ConstantDescs.CD_Map, "ofEntries", MethodTypeDesc.of(java.lang.constant.ConstantDescs.CD_Map, ConstantDescs.CD_Entry.arrayType()), args));
    }

    private static final <E> ConstantDesc[] elements(Collection<? extends E> source, Function<? super E, ? extends Optional<? extends ConstantDesc>> f) {
        if (f == null) {
            f = Constables::describeConstable;
        }
        ConstantDesc[] args = new ConstantDesc[source.size()];
        int i = 0;
        for (E element : source) {
            Optional<ConstantDesc> arg;
            if (element instanceof Constable) {
                Constable c = (Constable)element;
                v0 = c.describeConstable();
            } else {
                v0 = arg = f.apply(element);
            }
            if (arg == null || arg.isEmpty()) {
                return EMPTY_CONSTANTDESC_ARRAY;
            }
            args[i++] = arg.orElseThrow();
        }
        return args;
    }

    private static final <K, V> ConstantDesc[] entries(Map<? extends K, ? extends V> map, Function<? super K, ? extends Optional<? extends ConstantDesc>> kf, Function<? super V, ? extends Optional<? extends ConstantDesc>> vf, boolean rejectNulls) {
        if (map.isEmpty()) {
            return EMPTY_CONSTANTDESC_ARRAY;
        }
        ConstantDesc[] args = new ConstantDesc[map.size()];
        int i = 0;
        for (Map.Entry<K, V> entry : map.entrySet()) {
            if (rejectNulls && (entry.getKey() == null || entry.getValue() == null)) {
                return EMPTY_CONSTANTDESC_ARRAY;
            }
            Optional<ConstantDesc> e = Constables.describeConstable(entry, kf, vf);
            if (e.isEmpty()) {
                return EMPTY_CONSTANTDESC_ARRAY;
            }
            args[i++] = e.orElseThrow();
        }
        return args;
    }

    private static final DynamicConstantDesc<?> construct(ClassDesc cd, ClassDesc[] constructorParameterTypes, ConstantDesc ... args) {
        ConstantDesc[] newArgs = new ConstantDesc[args == null || args.length <= 0 ? 1 : args.length + 1];
        newArgs[0] = MethodHandleDesc.ofConstructor(cd, constructorParameterTypes);
        if (newArgs.length > 1) {
            System.arraycopy(args, 0, newArgs, 1, args.length);
        }
        return DynamicConstantDesc.of(java.lang.constant.ConstantDescs.BSM_INVOKE, newArgs);
    }

    private static final DynamicConstantDesc<?> callInterfaceStatic(ClassDesc cd, String name, ClassDesc returnType) {
        return Constables.callInterfaceStatic(cd, name, MethodTypeDesc.of(returnType, new ClassDesc[0]), new ConstantDesc[0]);
    }

    private static final DynamicConstantDesc<?> callInterfaceStatic(ClassDesc cd, String name, MethodTypeDesc sig, ConstantDesc ... args) {
        return Constables.call(DirectMethodHandleDesc.Kind.INTERFACE_STATIC, cd, name, sig, args);
    }

    private static final DynamicConstantDesc<?> callStatic(ClassDesc cd, String name, MethodTypeDesc sig, ConstantDesc ... args) {
        return Constables.call(DirectMethodHandleDesc.Kind.STATIC, cd, name, sig, args);
    }

    private static final DynamicConstantDesc<?> call(DirectMethodHandleDesc.Kind kind, ClassDesc cd, String name, MethodTypeDesc sig, ConstantDesc ... args) {
        ConstantDesc[] newArgs = new ConstantDesc[args == null || args.length == 0 ? 1 : args.length + 1];
        newArgs[0] = MethodHandleDesc.ofMethod(kind, cd, name, sig);
        if (newArgs.length > 1) {
            System.arraycopy(args, 0, newArgs, 1, args.length);
        }
        return DynamicConstantDesc.of(java.lang.constant.ConstantDescs.BSM_INVOKE, newArgs);
    }

    private static final <T> Optional<? extends ConstantDesc> empty(T ignored) {
        return Optional.empty();
    }

    private static final ConstantDesc describeComparator(Comparator<?> comparator, Function<? super Comparator<?>, ? extends Optional<? extends ConstantDesc>> cf) {
        ConstantDesc constantDesc;
        if (comparator == null) {
            constantDesc = java.lang.constant.ConstantDescs.NULL;
        } else if (comparator instanceof Constable) {
            Constable c = (Constable)((Object)comparator);
            constantDesc = c.describeConstable().orElse(null);
        } else {
            constantDesc = cf == null ? null : (ConstantDesc)cf.apply(comparator).orElse(null);
        }
        return constantDesc;
    }

    private static final DynamicConstantDesc<?> asList(ConstantDesc[] args) {
        return Constables.callStatic(ConstantDescs.CD_Arrays, "asList", MethodTypeDesc.of(java.lang.constant.ConstantDescs.CD_List, java.lang.constant.ConstantDescs.CD_Object.arrayType()), args);
    }
}

