/*
 * Decompiled with CFR 0.152.
 */
package org.microbean.attributes;

import java.lang.constant.ClassDesc;
import java.lang.constant.ConstantDescs;
import java.lang.constant.DirectMethodHandleDesc;
import java.lang.constant.DynamicConstantDesc;
import java.lang.constant.MethodHandleDesc;
import java.lang.constant.MethodTypeDesc;
import java.util.List;
import java.util.Optional;
import org.microbean.attributes.Value;
import org.microbean.constant.Constables;

public record ListValue<T extends Value<T>>(List<T> value) implements Value<ListValue<T>>
{
    public ListValue {
        value = List.copyOf(value);
    }

    @Override
    public final int compareTo(ListValue<T> other) {
        if (other == null) {
            return -1;
        }
        if (this.equals(other)) {
            return 0;
        }
        return this.toString().compareTo(other.toString());
    }

    public final Optional<DynamicConstantDesc<ListValue<T>>> describeConstable() {
        ClassDesc me = ClassDesc.of(this.getClass().getName());
        return Constables.describeConstable(this.value()).map(valueDesc -> DynamicConstantDesc.of(ConstantDescs.BSM_INVOKE, MethodHandleDesc.ofMethod(DirectMethodHandleDesc.Kind.STATIC, me, "of", MethodTypeDesc.of(me, ConstantDescs.CD_List)), valueDesc));
    }

    @Override
    public final boolean equals(Object other) {
        return other == this || other != null && other.getClass() == this.getClass() && this.value().equals(((ListValue)other).value());
    }

    @Override
    public final int hashCode() {
        return this.value().hashCode();
    }

    @Override
    public final String toString() {
        return this.value().toString();
    }

    public static final <T extends Value<T>> ListValue<T> of(List<T> value) {
        return new ListValue<T>(value);
    }
}

