/*
 * Decompiled with CFR 0.152.
 */
package org.microbean.attributes;

import java.lang.constant.ClassDesc;
import java.lang.constant.ConstantDescs;
import java.lang.constant.DirectMethodHandleDesc;
import java.lang.constant.DynamicConstantDesc;
import java.lang.constant.MethodHandleDesc;
import java.lang.constant.MethodTypeDesc;
import java.util.Objects;
import java.util.Optional;
import org.microbean.attributes.Value;

public record ClassValue(Class<?> value) implements Value<ClassValue>
{
    public static final ClassValue CLASS_JAVA_LANG_OBJECT = new ClassValue(Object.class);
    public static final ClassValue CLASS_JAVA_LANG_STRING = new ClassValue(String.class);

    public ClassValue {
        Objects.requireNonNull(value, "value");
    }

    @Override
    public final int compareTo(ClassValue other) {
        if (other == null) {
            return -1;
        }
        if (this.equals(other)) {
            return 0;
        }
        return this.value().getName().compareTo(other.value().getName());
    }

    public final Optional<DynamicConstantDesc<ClassValue>> describeConstable() {
        ClassDesc cd = ClassDesc.of(this.getClass().getName());
        return Optional.of(DynamicConstantDesc.of(ConstantDescs.BSM_INVOKE, MethodHandleDesc.ofMethod(DirectMethodHandleDesc.Kind.STATIC, cd, "of", MethodTypeDesc.of(cd, ConstantDescs.CD_Class)), this.value().describeConstable().orElseThrow()));
    }

    @Override
    public final boolean equals(Object other) {
        return other == this || other != null && other.getClass() == this.getClass() && this.value().equals(((ClassValue)other).value());
    }

    @Override
    public final int hashCode() {
        return this.value().hashCode();
    }

    @Override
    public final String toString() {
        return this.value().getName();
    }

    public static final ClassValue of(Class<?> c) {
        return c == Object.class ? CLASS_JAVA_LANG_OBJECT : (c == String.class ? CLASS_JAVA_LANG_STRING : new ClassValue(c));
    }
}

