/*
 * Decompiled with CFR 0.152.
 */
package org.microbean.attributes;

import java.lang.constant.ClassDesc;
import java.lang.constant.ConstantDescs;
import java.lang.constant.DirectMethodHandleDesc;
import java.lang.constant.DynamicConstantDesc;
import java.lang.constant.MethodHandleDesc;
import java.lang.constant.MethodTypeDesc;
import java.util.Optional;
import org.microbean.attributes.Value;

public record BooleanValue(boolean value) implements Value<BooleanValue>
{
    public static final BooleanValue TRUE = new BooleanValue(true);
    public static final BooleanValue FALSE = new BooleanValue(false);

    @Override
    public final int compareTo(BooleanValue other) {
        if (other == null) {
            return -1;
        }
        if (this.equals(other)) {
            return 0;
        }
        if (this.value()) {
            return 1;
        }
        return -1;
    }

    public final Optional<DynamicConstantDesc<BooleanValue>> describeConstable() {
        ClassDesc cd = ClassDesc.of(this.getClass().getName());
        return Optional.of(DynamicConstantDesc.of(ConstantDescs.BSM_INVOKE, MethodHandleDesc.ofMethod(DirectMethodHandleDesc.Kind.STATIC, cd, "of", MethodTypeDesc.of(cd, ConstantDescs.CD_boolean)), this.value() ? ConstantDescs.TRUE : ConstantDescs.FALSE));
    }

    @Override
    public final boolean equals(Object other) {
        return other == this || other != null && other.getClass() == this.getClass() && this.value() == ((BooleanValue)other).value();
    }

    @Override
    public final int hashCode() {
        return Boolean.valueOf(this.value()).hashCode();
    }

    @Override
    public final String toString() {
        return String.valueOf(this.value());
    }

    public static final BooleanValue of(boolean b) {
        return b ? TRUE : FALSE;
    }
}

