/*
 * Decompiled with CFR 0.152.
 */
package org.microbean.attributes;

import java.lang.constant.ClassDesc;
import java.lang.constant.ConstantDescs;
import java.lang.constant.DirectMethodHandleDesc;
import java.lang.constant.DynamicConstantDesc;
import java.lang.constant.MethodHandleDesc;
import java.lang.constant.MethodTypeDesc;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import org.microbean.attributes.BooleanValue;
import org.microbean.attributes.ByteValue;
import org.microbean.attributes.CharValue;
import org.microbean.attributes.ClassValue;
import org.microbean.attributes.DoubleValue;
import org.microbean.attributes.FloatValue;
import org.microbean.attributes.IntValue;
import org.microbean.attributes.LongValue;
import org.microbean.attributes.ShortValue;
import org.microbean.attributes.StringValue;
import org.microbean.attributes.Value;
import org.microbean.constant.Constables;

public final class ArrayValue<T extends Value<T>>
extends Record
implements Value<ArrayValue<T>> {
    private final T[] value;
    private static final Value<?>[] EMPTY_VALUE_ARRAY = new Value[0];

    public ArrayValue(T[] value) {
        value = (Value[])value.clone();
        this.value = value;
    }

    @Override
    public final int compareTo(ArrayValue<T> other) {
        if (other == null) {
            return -1;
        }
        if (this.equals(other)) {
            return 0;
        }
        return this.toString().compareTo(other.toString());
    }

    public final Optional<DynamicConstantDesc<ArrayValue<T>>> describeConstable() {
        ClassDesc me = ClassDesc.of(this.getClass().getName());
        return Constables.describeConstable(Arrays.asList(this.value())).map(valueDesc -> DynamicConstantDesc.of(ConstantDescs.BSM_INVOKE, MethodHandleDesc.ofMethod(DirectMethodHandleDesc.Kind.STATIC, me, "of", MethodTypeDesc.of(me, ConstantDescs.CD_List)), valueDesc));
    }

    @Override
    public final boolean equals(Object other) {
        return other == this || other != null && other.getClass() == this.getClass() && Arrays.equals(this.value(), ((ArrayValue)other).value());
    }

    @Override
    public final int hashCode() {
        return Arrays.hashCode(this.value());
    }

    @Override
    public final String toString() {
        return Arrays.asList(this.value()).toString();
    }

    public final T[] value() {
        return (Value[])this.value.clone();
    }

    public static final ArrayValue<BooleanValue> of(boolean ... values) {
        Value[] va = new BooleanValue[values.length];
        for (int i = 0; i < values.length; ++i) {
            va[i] = BooleanValue.of(values[i]);
        }
        return new ArrayValue(va);
    }

    public static final ArrayValue<ByteValue> of(byte ... values) {
        Value[] va = new ByteValue[values.length];
        for (int i = 0; i < values.length; ++i) {
            va[i] = ByteValue.of(values[i]);
        }
        return new ArrayValue(va);
    }

    public static final ArrayValue<CharValue> of(char ... values) {
        Value[] va = new CharValue[values.length];
        for (int i = 0; i < values.length; ++i) {
            va[i] = CharValue.of(values[i]);
        }
        return new ArrayValue(va);
    }

    public static final ArrayValue<DoubleValue> of(double ... values) {
        Value[] va = new DoubleValue[values.length];
        for (int i = 0; i < values.length; ++i) {
            va[i] = DoubleValue.of(values[i]);
        }
        return new ArrayValue(va);
    }

    public static final ArrayValue<FloatValue> of(float ... values) {
        Value[] va = new FloatValue[values.length];
        for (int i = 0; i < values.length; ++i) {
            va[i] = FloatValue.of(values[i]);
        }
        return new ArrayValue(va);
    }

    public static final ArrayValue<IntValue> of(int ... values) {
        Value[] va = new IntValue[values.length];
        for (int i = 0; i < values.length; ++i) {
            va[i] = IntValue.of(values[i]);
        }
        return new ArrayValue(va);
    }

    public static final ArrayValue<LongValue> of(long ... values) {
        Value[] va = new LongValue[values.length];
        for (int i = 0; i < values.length; ++i) {
            va[i] = LongValue.of(values[i]);
        }
        return new ArrayValue(va);
    }

    public static final ArrayValue<ShortValue> of(short ... values) {
        Value[] va = new ShortValue[values.length];
        for (int i = 0; i < values.length; ++i) {
            va[i] = ShortValue.of(values[i]);
        }
        return new ArrayValue(va);
    }

    public static final ArrayValue<ClassValue> of(Class<?> ... values) {
        Value[] va = new ClassValue[values.length];
        for (int i = 0; i < values.length; ++i) {
            va[i] = ClassValue.of(values[i]);
        }
        return new ArrayValue(va);
    }

    public static final ArrayValue<StringValue> of(String ... values) {
        Value[] va = new StringValue[values.length];
        for (int i = 0; i < values.length; ++i) {
            va[i] = StringValue.of(values[i]);
        }
        return new ArrayValue(va);
    }

    public static final <T extends Value<T>> ArrayValue<T> of(List<T> value) {
        return ArrayValue.of((Value[])value.toArray(EMPTY_VALUE_ARRAY));
    }

    public static final <T extends Value<T>> ArrayValue<T> of(T[] value) {
        return new ArrayValue(value);
    }
}

