/*
 * Decompiled with CFR 0.152.
 */
package org.microbean.attributes;

import java.lang.constant.ClassDesc;
import java.lang.constant.ConstantDesc;
import java.lang.constant.ConstantDescs;
import java.lang.constant.DirectMethodHandleDesc;
import java.lang.constant.DynamicConstantDesc;
import java.lang.constant.MethodHandleDesc;
import java.lang.constant.MethodTypeDesc;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.TreeMap;
import org.microbean.attributes.Attributed;
import org.microbean.attributes.StringValue;
import org.microbean.attributes.Value;
import org.microbean.constant.Constables;

public record Attributes(String name, Map<String, Value<?>> values, Map<String, Value<?>> notes, Map<String, List<Attributes>> attributesMap) implements Attributed,
Value<Attributes>
{
    public Attributes {
        Objects.requireNonNull(name, "name");
        switch (values.size()) {
            case 0: {
                values = Map.of();
                break;
            }
            case 1: {
                values = Map.copyOf(values);
                break;
            }
            default: {
                TreeMap<String, Value<Object>> sortedValues = new TreeMap<String, Value<Object>>();
                sortedValues.putAll(values);
                values = Collections.unmodifiableSortedMap(sortedValues);
            }
        }
        if (values.containsKey("")) {
            throw new IllegalArgumentException("values: " + String.valueOf(values));
        }
        switch (notes.size()) {
            case 0: {
                notes = Map.of();
                break;
            }
            case 1: {
                notes = Map.copyOf(notes);
                break;
            }
            default: {
                TreeMap<String, Value<Object>> sortedNotes = new TreeMap<String, Value<Object>>();
                sortedNotes.putAll(notes);
                notes = Collections.unmodifiableSortedMap(sortedNotes);
            }
        }
        if (notes.containsKey("")) {
            throw new IllegalArgumentException("notes: " + String.valueOf(notes));
        }
        switch (attributesMap.size()) {
            case 0: {
                attributesMap = Map.of();
                break;
            }
            case 1: {
                attributesMap = Map.copyOf(attributesMap);
                break;
            }
            default: {
                TreeMap sortedAttributesMap = new TreeMap();
                for (Map.Entry<String, List<Attributes>> e : attributesMap.entrySet()) {
                    sortedAttributesMap.put(e.getKey(), List.copyOf((Collection)e.getValue()));
                }
                attributesMap = Collections.unmodifiableSortedMap(sortedAttributesMap);
            }
        }
        if (attributesMap.containsKey("")) {
            throw new IllegalArgumentException("attributesMap: " + String.valueOf(attributesMap));
        }
    }

    @Override
    public final List<Attributes> attributes() {
        return this.attributes(this.name());
    }

    public final List<Attributes> attributes(String key) {
        return this.attributesMap().getOrDefault(key, List.of());
    }

    @Override
    public final int compareTo(Attributes other) {
        if (other == null) {
            return -1;
        }
        if (this.equals(other)) {
            return 0;
        }
        int c = (this.name() + String.valueOf(this.values())).compareTo(other.name() + String.valueOf(other.values()));
        return c != 0 ? c : (this.notes().toString() + String.valueOf(this.attributesMap())).compareTo(other.notes().toString() + String.valueOf(other.attributesMap()));
    }

    public final Optional<DynamicConstantDesc<Attributes>> describeConstable() {
        ClassDesc me = ClassDesc.of(this.getClass().getName());
        return Constables.describeConstable(this.values()).flatMap(valuesDesc -> Constables.describeConstable(this.notes()).flatMap(notesDesc -> Constables.describeConstable(this.attributesMap()).map(attributesDesc -> DynamicConstantDesc.of(ConstantDescs.BSM_INVOKE, new ConstantDesc[]{MethodHandleDesc.ofMethod(DirectMethodHandleDesc.Kind.STATIC, me, "of", MethodTypeDesc.of(me, ConstantDescs.CD_String, ConstantDescs.CD_Map, ConstantDescs.CD_Map, ConstantDescs.CD_Map)), this.name(), valuesDesc, notesDesc, attributesDesc}))));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public final boolean equals(Object other) {
        if (other == this) return true;
        if (!(other instanceof Attributes)) return false;
        Attributes a = (Attributes)other;
        if (!this.name().equals(a.name())) return false;
        if (!this.values().equals(a.values())) return false;
        return true;
    }

    @Override
    public final int hashCode() {
        int hashCode = 0;
        for (Map.Entry<String, Value<?>> e : this.values().entrySet()) {
            hashCode += 127 * e.getKey().hashCode() ^ e.getValue().hashCode();
        }
        return hashCode;
    }

    public final <T extends Value<T>> T value(String name) {
        return (T)this.values().get(name);
    }

    public static final Attributes of(String name) {
        return Attributes.of(name, Map.of(), Map.of(), Map.of());
    }

    public static final Attributes of(String name, String valueValue) {
        return Attributes.of(name, Map.of("value", new StringValue(valueValue)), Map.of(), Map.of());
    }

    public static final Attributes of(String name, Attributes ... attributes) {
        return Attributes.of(name, attributes == null || attributes.length == 0 ? List.of() : Arrays.asList(attributes));
    }

    public static final Attributes of(String name, List<Attributes> attributes) {
        return Attributes.of(name, Map.of(), Map.of(), Map.of(name, attributes));
    }

    public static final Attributes of(String name, Map<String, Value<?>> values, Map<String, Value<?>> notes, Map<String, List<Attributes>> attributes) {
        return new Attributes(name, values, notes, attributes);
    }
}

