/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.proj4j.proj;

import org.locationtech.proj4j.ProjCoordinate;
import org.locationtech.proj4j.ProjectionException;
import org.locationtech.proj4j.proj.Projection;
import org.locationtech.proj4j.util.ProjectionMath;

public class UrmaevFlatPolarSinusoidalProjection
extends Projection {
    private static final double C_x = 0.8773826753;
    private static final double Cy = 1.139753528477;
    private double n = 0.8660254037844386;
    private double C_y;

    @Override
    public ProjCoordinate project(double lplam, double lpphi, ProjCoordinate out) {
        out.y = ProjectionMath.asin(this.n * Math.sin(lpphi));
        out.x = 0.8773826753 * lplam * Math.cos(lpphi);
        out.y = this.C_y * lpphi;
        return out;
    }

    @Override
    public ProjCoordinate projectInverse(double xyx, double xyy, ProjCoordinate out) {
        out.y = ProjectionMath.asin(Math.sin(xyy /= this.C_y) / this.n);
        out.x = xyx / (0.8773826753 * Math.cos(xyy));
        return out;
    }

    @Override
    public boolean hasInverse() {
        return true;
    }

    @Override
    public void initialize() {
        super.initialize();
        if (this.n <= 0.0 || this.n > 1.0) {
            throw new ProjectionException("-40");
        }
        this.C_y = 1.139753528477 / this.n;
    }

    public void setN(double n) {
        this.n = n;
    }

    public double getN() {
        return this.n;
    }

    @Override
    public String toString() {
        return "Urmaev Flat-Polar Sinusoidal";
    }
}

