/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.proj4j.proj;

import org.locationtech.proj4j.ProjCoordinate;
import org.locationtech.proj4j.ProjectionException;
import org.locationtech.proj4j.proj.Projection;
import org.locationtech.proj4j.util.ProjectionMath;

public class GeostationarySatelliteProjection
extends Projection {
    private double _radiusP;
    private double _radiusP2;
    private double _radiusPInv2;
    private double _radiusG;
    private double _radiusG1;
    private double _c;

    public GeostationarySatelliteProjection() {
        this.name = "Geostationary";
        this.initialize();
    }

    @Override
    public void initialize() {
        super.initialize();
        this._radiusG1 = this.heightOfOrbit / this.a;
        this._radiusG = 1.0 + this._radiusG1;
        this._c = this._radiusG * this._radiusG - 1.0;
        if (!this.spherical) {
            this._radiusP = Math.sqrt(this.one_es);
            this._radiusP2 = this.one_es;
            this._radiusPInv2 = this.rone_es;
        } else {
            this._radiusPInv2 = 1.0;
            this._radiusP2 = 1.0;
            this._radiusP = 1.0;
        }
    }

    @Override
    public ProjCoordinate project(double lplam, double lpphi, ProjCoordinate out) {
        if (this.spherical) {
            this.project_s(lplam, lpphi, out);
        } else {
            this.project_e(lplam, lpphi, out);
        }
        return out;
    }

    public void project_s(double lplam, double lpphi, ProjCoordinate out) {
        double vz;
        double vy;
        double tmp = Math.cos(lpphi);
        double vx = Math.cos(lplam) * tmp;
        if ((this._radiusG - vx) * vx - (vy = Math.sin(lplam) * tmp) * vy - (vz = Math.sin(lpphi)) * vz < 0.0) {
            out.x = Double.NaN;
            out.y = Double.NaN;
            return;
        }
        tmp = this._radiusG - vx;
        out.x = this._radiusG1 * Math.atan(vy / tmp);
        out.y = this._radiusG1 * Math.atan(vz / ProjectionMath.hypot(vy, tmp));
    }

    public void project_e(double lplam, double lpphi, ProjCoordinate out) {
        double vz;
        double vy;
        double r = this._radiusP / ProjectionMath.hypot(this._radiusP * Math.cos(lpphi = Math.atan(this._radiusP2 * Math.tan(lpphi))), Math.sin(lpphi));
        double vx = r * Math.cos(lplam) * Math.cos(lpphi);
        if ((this._radiusG - vx) * vx - (vy = r * Math.sin(lplam) * Math.cos(lpphi)) * vy - (vz = r * Math.sin(lpphi)) * vz * this._radiusPInv2 < 0.0) {
            out.x = Double.NaN;
            out.y = Double.NaN;
            return;
        }
        double tmp = this._radiusG - vx;
        out.x = this._radiusG1 * Math.atan(vy / tmp);
        out.y = this._radiusG1 * Math.atan(vz / ProjectionMath.hypot(vy, tmp));
    }

    @Override
    public ProjCoordinate projectInverse(double xyx, double xyy, ProjCoordinate out) {
        if (this.spherical) {
            this.projectInverse_s(xyx, xyy, out);
        } else {
            this.projectInverse_e(xyx, xyy, out);
        }
        return out;
    }

    public void projectInverse_s(double xyx, double xyy, ProjCoordinate out) {
        double d;
        double vx = -1.0;
        double vy = Math.tan(xyx / (this._radiusG - 1.0));
        double vz = Math.tan(xyy / (this._radiusG - 1.0)) * Math.sqrt(1.0 + vy * vy);
        double a = vy * vy + vz * vz + vx * vx;
        double b = 2.0 * this._radiusG * vx;
        double det = b * b - 4.0 * a * this._c;
        if (d < 0.0) {
            throw new ProjectionException();
        }
        double k = (-b - Math.sqrt(det)) / (2.0 * a);
        vx = this._radiusG + k * vx;
        double lplam = Math.atan2(vy *= k, vx);
        double lpphi = Math.atan((vz *= k) * Math.cos(lplam) / vx);
        out.x = lplam;
        out.y = lpphi;
    }

    public void projectInverse_e(double xyx, double xyy, ProjCoordinate out) {
        double d;
        double vx = -1.0;
        double vy = Math.tan(xyx / this._radiusG1);
        double vz = Math.tan(xyy / this._radiusG1) * ProjectionMath.hypot(1.0, vy);
        double a = vz / this._radiusP;
        a = vy * vy + a * a + vx * vx;
        double b = 2.0 * this._radiusG * vx;
        double det = b * b - 4.0 * a * this._c;
        if (d < 0.0) {
            throw new ProjectionException();
        }
        double k = (-b - Math.sqrt(det)) / (2.0 * a);
        vx = this._radiusG + k * vx;
        double lplam = Math.atan2(vy *= k, vx);
        double lpphi = Math.atan((vz *= k) * Math.cos(lplam) / vx);
        lpphi = Math.atan(this._radiusPInv2 * Math.tan(lpphi));
        out.x = lplam;
        out.y = lpphi;
    }

    @Override
    public boolean isEqualArea() {
        return false;
    }

    @Override
    public boolean hasInverse() {
        return true;
    }

    @Override
    public String toString() {
        return "Geostationary Satellite";
    }
}

