/*
 * Decompiled with CFR 0.152.
 */
package org.metafacture.xml;

import java.util.HashSet;
import org.metafacture.commons.XmlUtil;
import org.metafacture.framework.FluxCommand;
import org.metafacture.framework.StreamReceiver;
import org.metafacture.framework.XmlReceiver;
import org.metafacture.framework.annotations.Description;
import org.metafacture.framework.annotations.In;
import org.metafacture.framework.annotations.Out;
import org.metafacture.framework.helpers.DefaultXmlPipe;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

@Description(value="Splits elements (e.g. defining single records) residing in one XML document into multiple single XML documents.")
@In(value=XmlReceiver.class)
@Out(value=StreamReceiver.class)
@FluxCommand(value="split-xml-elements")
public final class XmlElementSplitter
extends DefaultXmlPipe<StreamReceiver> {
    private String Element;
    private StringBuilder builder = new StringBuilder();
    private HashSet<String> namespaces = new HashSet();
    private boolean inElement = false;
    private int recordCnt = 0;
    private String root;
    private String rootStart = "";
    private String rootEnd = "";
    private String xmlDeclaration = "<?xml version = \"1.0\" encoding = \"UTF-8\"?>";
    private int ElementDepth = 0;

    public XmlElementSplitter() {
    }

    public XmlElementSplitter(String aTopLevelElement, String aElementName) {
        this.setTopLevelElement(aTopLevelElement);
        this.setElementName(aElementName);
    }

    public void setElementName(String name) {
        this.Element = name;
    }

    public void setTopLevelElement(String root) {
        this.root = root;
        this.rootStart = "<" + root;
        this.rootEnd = "</" + root + ">";
    }

    public void setXmlDeclaration(String xmlDeclaration) {
        this.xmlDeclaration = xmlDeclaration;
    }

    public void startPrefixMapping(String prefix, String uri) throws SAXException {
        super.startPrefixMapping(prefix, uri);
        if (this.root != null & !prefix.isEmpty() && uri != null) {
            this.namespaces.add(" xmlns:" + prefix + "=\"" + uri + "\"");
        }
    }

    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        if (!this.inElement) {
            if (this.Element.equals(localName)) {
                this.builder = new StringBuilder();
                ((StreamReceiver)this.getReceiver()).startRecord(String.valueOf(this.recordCnt++));
                this.inElement = true;
                this.appendValuesToElement(qName, attributes);
                ++this.ElementDepth;
            }
        } else {
            if (this.Element.equals(localName)) {
                ++this.ElementDepth;
            }
            this.appendValuesToElement(qName, attributes);
        }
    }

    private void appendValuesToElement(String qName, Attributes attributes) {
        this.builder.append("<" + qName);
        if (attributes.getLength() > 0) {
            for (int i = 0; i < attributes.getLength(); ++i) {
                this.builder.append(" " + attributes.getQName(i) + "=\"" + XmlUtil.escape((String)attributes.getValue(i)) + "\"");
            }
        }
        this.builder.append(">");
    }

    public void endElement(String uri, String localName, String qName) throws SAXException {
        if (this.inElement) {
            this.builder.append("</" + qName + ">");
            if (this.Element.equals(localName)) {
                if (this.ElementDepth <= 1) {
                    StringBuilder sb = new StringBuilder(this.xmlDeclaration + this.rootStart);
                    if (this.root != null && this.namespaces.size() > 0) {
                        for (String ns : this.namespaces) {
                            sb.append(ns);
                        }
                        sb.append(">");
                    }
                    this.builder.insert(0, sb.toString()).append(this.rootEnd);
                    ((StreamReceiver)this.getReceiver()).literal("Element", this.builder.toString());
                    ((StreamReceiver)this.getReceiver()).endRecord();
                    this.reset();
                    return;
                }
                --this.ElementDepth;
            }
        }
    }

    public void characters(char[] chars, int start, int length) throws SAXException {
        try {
            this.builder.append(XmlUtil.escape((String)new String(chars, start, length)));
        }
        catch (Exception e) {
            this.reset();
        }
    }

    private void reset() {
        this.inElement = false;
        this.builder = new StringBuilder();
        this.ElementDepth = 0;
    }

    public String getXmlDeclaration() {
        return this.xmlDeclaration;
    }

    public void onResetStream() {
        this.reset();
    }
}

