/*
 * Decompiled with CFR 0.152.
 */
package org.metafacture.xml;

import org.metafacture.framework.FluxCommand;
import org.metafacture.framework.FormatException;
import org.metafacture.framework.StreamReceiver;
import org.metafacture.framework.XmlReceiver;
import org.metafacture.framework.annotations.Description;
import org.metafacture.framework.annotations.In;
import org.metafacture.framework.annotations.Out;
import org.metafacture.framework.helpers.DefaultXmlPipe;
import org.xml.sax.Attributes;

@Description(value="Reads CG-XML files")
@In(value=XmlReceiver.class)
@Out(value=StreamReceiver.class)
@FluxCommand(value="handle-cg-xml")
public final class CGXmlHandler
extends DefaultXmlPipe<StreamReceiver> {
    public static final String CGXML_NAMESPACE = "http://www.culturegraph.org/cgxml";
    private static final String ROOT_TAG = "cgxml";
    private static final String RECORDS_TAG = "records";
    private static final String RECORD_TAG = "record";
    private static final String ENTITY_TAG = "entity";
    private static final String LITERAL_TAG = "literal";
    private static final String VERSION_ATTR = "version";
    private static final String ID_ATTR = "id";
    private static final String NAME_ATTR = "name";
    private static final String VALUE_ATTR = "value";
    private static final String VERSION = "1.0";

    public void startElement(String uri, String localName, String qName, Attributes attributes) {
        if (!CGXML_NAMESPACE.equals(uri)) {
            return;
        }
        switch (localName) {
            case "cgxml": {
                this.verifyValidVersion(attributes);
                break;
            }
            case "records": {
                break;
            }
            case "record": {
                this.emitStartRecord(attributes);
                break;
            }
            case "entity": {
                this.emitStartEntity(attributes);
                break;
            }
            case "literal": {
                this.emitLiteral(attributes);
                break;
            }
            default: {
                throw new FormatException("Unexpected element: " + localName);
            }
        }
    }

    private void verifyValidVersion(Attributes attributes) {
        String version = attributes.getValue("", VERSION_ATTR);
        if (!VERSION.equals(version)) {
            throw new FormatException("Invalid cg-xml version: " + version);
        }
    }

    private void emitStartRecord(Attributes attributes) {
        String recordId = attributes.getValue("", ID_ATTR);
        if (recordId == null) {
            ((StreamReceiver)this.getReceiver()).startRecord("");
        } else {
            ((StreamReceiver)this.getReceiver()).startRecord(recordId);
        }
    }

    private void emitStartEntity(Attributes attributes) {
        String name = attributes.getValue("", NAME_ATTR);
        if (name == null) {
            throw new FormatException("Entity name must not be null");
        }
        ((StreamReceiver)this.getReceiver()).startEntity(name);
    }

    private void emitLiteral(Attributes attributes) {
        String name = attributes.getValue("", NAME_ATTR);
        String value = attributes.getValue("", VALUE_ATTR);
        if (name == null) {
            throw new FormatException("Literal name must not be null");
        }
        ((StreamReceiver)this.getReceiver()).literal(name, value);
    }

    public void endElement(String uri, String localName, String qName) {
        if (!CGXML_NAMESPACE.equals(uri)) {
            return;
        }
        if (RECORD_TAG.equals(localName)) {
            ((StreamReceiver)this.getReceiver()).endRecord();
        } else if (ENTITY_TAG.equals(localName)) {
            ((StreamReceiver)this.getReceiver()).endEntity();
        }
    }
}

