/*
 * Decompiled with CFR 0.152.
 */
package org.metafacture.triples;

import org.metafacture.framework.FluxCommand;
import org.metafacture.framework.ObjectReceiver;
import org.metafacture.framework.annotations.Description;
import org.metafacture.framework.annotations.In;
import org.metafacture.framework.annotations.Out;
import org.metafacture.framework.helpers.DefaultObjectPipe;
import org.metafacture.framework.objects.Triple;

@Description(value="Shifts subjectTo predicateTo and objectTo around")
@In(value=Triple.class)
@Out(value=Triple.class)
@FluxCommand(value="reorder-triple")
public final class TripleReorder
extends DefaultObjectPipe<Triple, ObjectReceiver<Triple>> {
    private TripleElement subjectFrom = TripleElement.SUBJECT;
    private TripleElement predicateFrom = TripleElement.PREDICATE;
    private TripleElement objectFrom = TripleElement.OBJECT;

    public TripleElement getSubjectFrom() {
        return this.subjectFrom;
    }

    public TripleElement getPredicateFrom() {
        return this.predicateFrom;
    }

    public TripleElement getObjectFrom() {
        return this.objectFrom;
    }

    public void setSubjectFrom(TripleElement subjectFrom) {
        this.subjectFrom = subjectFrom;
    }

    public void setPredicateFrom(TripleElement predicateFrom) {
        this.predicateFrom = predicateFrom;
    }

    public void setObjectFrom(TripleElement objectFrom) {
        this.objectFrom = objectFrom;
    }

    public void process(Triple triple) {
        String[] elements = new String[]{triple.getSubject(), triple.getPredicate(), triple.getObject()};
        ((ObjectReceiver)this.getReceiver()).process((Object)new Triple(elements[this.subjectFrom.ordinal()], elements[this.predicateFrom.ordinal()], elements[this.objectFrom.ordinal()]));
    }

    public static enum TripleElement {
        SUBJECT,
        PREDICATE,
        OBJECT;

    }
}

