/*
 * Decompiled with CFR 0.152.
 */
package org.metafacture.triples;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import org.metafacture.commons.ResourceUtil;
import org.metafacture.framework.FluxCommand;
import org.metafacture.framework.MetafactureException;
import org.metafacture.framework.ObjectReceiver;
import org.metafacture.framework.annotations.Description;
import org.metafacture.framework.annotations.In;
import org.metafacture.framework.annotations.Out;
import org.metafacture.framework.helpers.DefaultObjectPipe;
import org.metafacture.framework.objects.Triple;

@Description(value="Uses the object value of the triple as a URL and emits a new triple in which the object value is replaced with the contents of the resource identified by the URL.")
@In(value=Triple.class)
@Out(value=Triple.class)
@FluxCommand(value="retrieve-triple-objects")
public final class TripleObjectRetriever
extends DefaultObjectPipe<Triple, ObjectReceiver<Triple>> {
    private Charset defaultEncoding = StandardCharsets.UTF_8;

    public void setDefaultEncoding(String defaultEncoding) {
        this.defaultEncoding = Charset.forName(defaultEncoding);
    }

    public void setDefaultEncoding(Charset defaultEncoding) {
        this.defaultEncoding = defaultEncoding;
    }

    public String getDefaultEncoding() {
        return this.defaultEncoding.name();
    }

    public void process(Triple triple) {
        assert (!this.isClosed());
        if (triple.getObjectType() != Triple.ObjectType.STRING) {
            return;
        }
        String objectValue = this.retrieveObjectValue(triple.getObject());
        ((ObjectReceiver)this.getReceiver()).process((Object)new Triple(triple.getSubject(), triple.getPredicate(), objectValue));
    }

    private String retrieveObjectValue(String urlString) {
        String string;
        block8: {
            URL url = new URL(urlString);
            URLConnection connection = url.openConnection();
            connection.connect();
            String encodingName = connection.getContentEncoding();
            Charset encoding = encodingName != null ? Charset.forName(encodingName) : this.defaultEncoding;
            InputStream inputStream = connection.getInputStream();
            try {
                string = ResourceUtil.readAll((InputStream)inputStream, (Charset)encoding);
                if (inputStream == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (inputStream != null) {
                        try {
                            inputStream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new MetafactureException((Throwable)e);
                }
            }
            inputStream.close();
        }
        return string;
    }
}

