/*
 * Decompiled with CFR 0.152.
 */
package org.metafacture.triples;

import org.metafacture.formeta.parser.Emitter;
import org.metafacture.formeta.parser.FormetaParser;
import org.metafacture.formeta.parser.PartialRecordEmitter;
import org.metafacture.framework.FluxCommand;
import org.metafacture.framework.StreamReceiver;
import org.metafacture.framework.annotations.Description;
import org.metafacture.framework.annotations.In;
import org.metafacture.framework.annotations.Out;
import org.metafacture.framework.helpers.DefaultObjectPipe;
import org.metafacture.framework.objects.Triple;

@Description(value="Collects named values to form records. The name becomes the id, the value is split by 'separator' into name and value")
@In(value=Triple.class)
@Out(value=StreamReceiver.class)
@FluxCommand(value="collect-triples")
public final class TripleCollect
extends DefaultObjectPipe<Triple, StreamReceiver> {
    private final FormetaParser parser = new FormetaParser();
    private final PartialRecordEmitter emitter = new PartialRecordEmitter();
    private String currentSubject;

    public TripleCollect() {
        this.parser.setEmitter((Emitter)this.emitter);
    }

    public void process(Triple triple) {
        if (this.currentSubject == null) {
            this.currentSubject = triple.getSubject();
            ((StreamReceiver)this.getReceiver()).startRecord(this.currentSubject);
        }
        if (this.currentSubject.equals(triple.getSubject())) {
            this.decodeTriple(triple);
        } else {
            ((StreamReceiver)this.getReceiver()).endRecord();
            this.currentSubject = triple.getSubject();
            ((StreamReceiver)this.getReceiver()).startRecord(this.currentSubject);
            this.decodeTriple(triple);
        }
    }

    public void decodeTriple(Triple triple) {
        if (triple.getObjectType() == Triple.ObjectType.STRING) {
            ((StreamReceiver)this.getReceiver()).literal(triple.getPredicate(), triple.getObject());
        } else if (triple.getObjectType() == Triple.ObjectType.ENTITY) {
            this.emitter.setDefaultName(triple.getPredicate());
            this.parser.parse(triple.getObject());
        } else {
            throw new UnsupportedOperationException(triple.getObjectType() + " can not yet be decoded");
        }
    }

    protected void onResetStream() {
        if (this.currentSubject != null) {
            this.currentSubject = null;
            ((StreamReceiver)this.getReceiver()).endRecord();
        }
    }

    protected void onCloseStream() {
        if (this.currentSubject != null) {
            this.currentSubject = null;
            ((StreamReceiver)this.getReceiver()).endRecord();
        }
    }

    protected void onSetReceiver() {
        this.emitter.setReceiver((StreamReceiver)this.getReceiver());
    }
}

