/*
 * Decompiled with CFR 0.152.
 */
package org.metafacture.triples;

import java.io.BufferedInputStream;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import org.metafacture.framework.MetafactureException;
import org.metafacture.framework.objects.Triple;

public final class SortedTripleFileFacade {
    public static final int BUFFERSIZE = 2048;
    private final ObjectInputStream in;
    private final File file;
    private Triple triple;
    private boolean empty;

    public SortedTripleFileFacade(File file) throws IOException {
        this.file = file;
        this.in = new ObjectInputStream(new BufferedInputStream(new FileInputStream(file), 2048));
        this.next();
    }

    public boolean isEmpty() {
        return this.empty;
    }

    private void next() throws IOException {
        try {
            this.triple = Triple.read((ObjectInputStream)this.in);
            this.empty = false;
        }
        catch (EOFException e) {
            this.empty = true;
            this.triple = null;
        }
    }

    public void close() {
        try {
            this.in.close();
        }
        catch (IOException e) {
            throw new MetafactureException("Error closing input stream", (Throwable)e);
        }
        if (this.file.exists()) {
            this.file.delete();
        }
    }

    public Triple peek() {
        if (this.isEmpty()) {
            return null;
        }
        return this.triple;
    }

    public Triple pop() throws IOException {
        Triple nextTriple = this.peek();
        this.next();
        return nextTriple;
    }
}

