/*
 * Decompiled with CFR 0.152.
 */
package org.metafacture.triples;

import java.lang.management.ManagementFactory;
import java.lang.management.MemoryMXBean;
import java.lang.management.MemoryPoolMXBean;
import java.lang.management.MemoryType;
import java.util.Collection;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.management.Notification;
import javax.management.NotificationEmitter;
import javax.management.NotificationListener;

final class MemoryWarningSystem {
    private static final MemoryPoolMXBean TENURED_GEN_POOL = MemoryWarningSystem.findTenuredGenPool();
    private static final double DEFAULT_THRESHOLD = 0.8;
    private static final Collection<Listener> LISTENERS = new CopyOnWriteArrayList<Listener>();

    private MemoryWarningSystem() {
    }

    private static Collection<Listener> getListeners() {
        return LISTENERS;
    }

    private static long getMaxMemory() {
        return TENURED_GEN_POOL.getUsage().getMax();
    }

    private static long getUsedMemory() {
        return TENURED_GEN_POOL.getUsage().getUsed();
    }

    static boolean addListener(Listener listener) {
        return LISTENERS.add(listener);
    }

    static boolean removeListener(Listener listener) {
        return LISTENERS.remove(listener);
    }

    private static void setUsageThreshold(double threshold) {
        if (threshold <= 0.0 || threshold > 1.0) {
            throw new IllegalArgumentException("'threshold' must be in [0.0, 1.0]");
        }
        TENURED_GEN_POOL.setUsageThreshold((long)((double)MemoryWarningSystem.getMaxMemory() * threshold));
    }

    private static MemoryPoolMXBean findTenuredGenPool() {
        for (MemoryPoolMXBean pool : ManagementFactory.getMemoryPoolMXBeans()) {
            if (pool.getType() != MemoryType.HEAP || !pool.isUsageThresholdSupported()) continue;
            return pool;
        }
        throw new AssertionError((Object)"Could not find tenured space");
    }

    static {
        MemoryWarningSystem.setUsageThreshold(0.8);
        MemoryMXBean mbean = ManagementFactory.getMemoryMXBean();
        NotificationEmitter emitter = (NotificationEmitter)((Object)mbean);
        emitter.addNotificationListener(new NotificationListener(){

            @Override
            public void handleNotification(Notification notification, Object handback) {
                if (notification.getType().equals("java.management.memory.threshold.exceeded")) {
                    for (Listener listener : MemoryWarningSystem.getListeners()) {
                        listener.memoryLow(MemoryWarningSystem.getUsedMemory(), MemoryWarningSystem.getMaxMemory());
                    }
                }
            }
        }, null, null);
    }

    static interface Listener {
        public void memoryLow(long var1, long var3);
    }
}

