/*
 * Decompiled with CFR 0.152.
 */
package org.metafacture.scripting;

import java.io.IOException;
import java.io.Reader;
import javax.script.Invocable;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import javax.script.ScriptException;
import org.metafacture.commons.ResourceUtil;
import org.metafacture.framework.FluxCommand;
import org.metafacture.framework.MetafactureException;
import org.metafacture.framework.ObjectReceiver;
import org.metafacture.framework.annotations.Description;
import org.metafacture.framework.annotations.In;
import org.metafacture.framework.annotations.Out;
import org.metafacture.framework.helpers.DefaultObjectPipe;

@Description(value="executes the function process(obj) in a given jscript")
@In(value=Object.class)
@Out(value=Object.class)
@FluxCommand(value="jscript")
public final class JScriptObjectPipe
extends DefaultObjectPipe<Object, ObjectReceiver<Object>> {
    private static final String PROCESS = "process";
    private String invoke = "process";
    private Invocable invocable;

    public JScriptObjectPipe(String script) {
        this.setScript(script);
    }

    public void setInvoke(String invoke) {
        this.invoke = invoke;
    }

    private void setScript(String file) {
        ScriptEngineManager manager = new ScriptEngineManager();
        ScriptEngine engine = manager.getEngineByName("JavaScript");
        try (Reader reader = ResourceUtil.getReader((String)file);){
            engine.eval(reader);
        }
        catch (ScriptException e) {
            throw new MetafactureException("Error in script", (Throwable)e);
        }
        catch (IOException e) {
            throw new MetafactureException("Error loading script '" + file + "'", (Throwable)e);
        }
        this.invocable = (Invocable)((Object)engine);
    }

    public void process(Object obj) {
        assert (!this.isClosed());
        try {
            Object retObj = this.invocable.invokeFunction(this.invoke, obj);
            ((ObjectReceiver)this.getReceiver()).process(retObj);
        }
        catch (ScriptException e) {
            throw new MetafactureException("Error in script while evaluating 'process' method", (Throwable)e);
        }
        catch (NoSuchMethodException e) {
            throw new MetafactureException("'process' method is missing in script", (Throwable)e);
        }
    }
}

