/*
 * Decompiled with CFR 0.152.
 */
package org.metafacture.runner.util;

import java.io.File;
import java.io.FilenameFilter;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import org.metafacture.framework.MetafactureException;

public final class DirectoryClassLoader
extends URLClassLoader {
    private static final String JAR_FILE_EXTENSION = ".jar";
    private static final String CLASS_FILE_EXTENSION = ".class";
    private static final FilenameFilter JAR_AND_CLASS_FILTER = new FilenameFilter(){

        @Override
        public boolean accept(File dir, String name) {
            return name.endsWith(DirectoryClassLoader.JAR_FILE_EXTENSION) || name.endsWith(DirectoryClassLoader.CLASS_FILE_EXTENSION);
        }
    };

    public DirectoryClassLoader(ClassLoader parent) {
        super(new URL[0], parent);
    }

    public void addDirectory(File dir) {
        for (File file : dir.listFiles(JAR_AND_CLASS_FILTER)) {
            try {
                this.addURL(file.toURI().toURL());
            }
            catch (MalformedURLException e) {
                throw new MetafactureException("Could not add " + file + " to class loader", (Throwable)e);
            }
        }
    }
}

