/*
 * Decompiled with CFR 0.152.
 */
package org.metafacture.monitoring;

import org.metafacture.framework.FluxCommand;
import org.metafacture.framework.StreamReceiver;
import org.metafacture.framework.annotations.Description;
import org.metafacture.framework.annotations.In;
import org.metafacture.framework.annotations.Out;
import org.metafacture.framework.helpers.DefaultStreamPipe;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Description(value="logs events")
@In(value=StreamReceiver.class)
@Out(value=StreamReceiver.class)
@FluxCommand(value="log-stream")
public final class StreamLogger
extends DefaultStreamPipe<StreamReceiver> {
    private static final Logger LOG = LoggerFactory.getLogger(StreamLogger.class);
    private final String logPrefix;

    public StreamLogger() {
        this("");
    }

    public StreamLogger(String logPrefix) {
        this.logPrefix = logPrefix;
    }

    public void startRecord(String identifier) {
        assert (!this.isClosed());
        LOG.debug("{}start record {}", (Object)this.logPrefix, (Object)identifier);
        if (null != this.getReceiver()) {
            ((StreamReceiver)this.getReceiver()).startRecord(identifier);
        }
    }

    public void endRecord() {
        assert (!this.isClosed());
        LOG.debug("{}end record", (Object)this.logPrefix);
        if (null != this.getReceiver()) {
            ((StreamReceiver)this.getReceiver()).endRecord();
        }
    }

    public void startEntity(String name) {
        assert (!this.isClosed());
        LOG.debug("{}start entity {}", (Object)this.logPrefix, (Object)name);
        if (null != this.getReceiver()) {
            ((StreamReceiver)this.getReceiver()).startEntity(name);
        }
    }

    public void endEntity() {
        assert (!this.isClosed());
        LOG.debug("{}end entity", (Object)this.logPrefix);
        if (null != this.getReceiver()) {
            ((StreamReceiver)this.getReceiver()).endEntity();
        }
    }

    public void literal(String name, String value) {
        assert (!this.isClosed());
        LOG.debug("{}literal {}={}", new Object[]{this.logPrefix, name, value});
        if (null != this.getReceiver()) {
            ((StreamReceiver)this.getReceiver()).literal(name, value);
        }
    }

    protected void onResetStream() {
        LOG.debug("{}resetStream", (Object)this.logPrefix);
    }

    protected void onCloseStream() {
        LOG.debug("{}closeStream", (Object)this.logPrefix);
    }
}

