/*
 * Decompiled with CFR 0.152.
 */
package org.metafacture.monitoring;

import java.util.HashMap;
import java.util.Map;
import org.metafacture.commons.StringUtil;
import org.metafacture.framework.FluxCommand;
import org.metafacture.framework.StreamReceiver;
import org.metafacture.framework.annotations.Description;
import org.metafacture.framework.annotations.In;
import org.metafacture.framework.annotations.Out;
import org.metafacture.framework.helpers.ForwardingStreamPipe;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Description(value="Writes log info every BATCHSIZE records. ")
@In(value=StreamReceiver.class)
@Out(value=StreamReceiver.class)
@FluxCommand(value="batch-log")
public final class StreamBatchLogger
extends ForwardingStreamPipe {
    public static final String RECORD_COUNT_VAR = "records";
    public static final String BATCH_COUNT_VAR = "batches";
    public static final String BATCH_SIZE_VAR = "batchSize";
    public static final String TOTAL_RECORD_COUNT_VAR = "totalRecords";
    public static final String DEFAULT_FORMAT = "records processed: ${totalRecords}";
    public static final long DEFAULT_BATCH_SIZE = 1000L;
    private static final Logger LOG = LoggerFactory.getLogger(StreamBatchLogger.class);
    private final Map<String, String> vars = new HashMap<String, String>();
    private final String format;
    private long batchSize = 1000L;
    private long recordCount;
    private long batchCount;

    public StreamBatchLogger() {
        this.format = DEFAULT_FORMAT;
    }

    public StreamBatchLogger(String format) {
        this.format = format;
    }

    public StreamBatchLogger(String format, Map<String, String> vars) {
        this.format = format;
        this.vars.putAll(vars);
    }

    public void setBatchSize(int batchSize) {
        this.batchSize = batchSize;
    }

    public long getBatchSize() {
        return this.batchSize;
    }

    public long getBatchCount() {
        return this.batchCount;
    }

    public long getRecordCount() {
        return this.recordCount;
    }

    public void endRecord() {
        ((StreamReceiver)this.getReceiver()).endRecord();
        ++this.recordCount;
        this.recordCount %= this.batchSize;
        if (this.recordCount == 0L) {
            ++this.batchCount;
            this.writeLog();
        }
    }

    protected void onCloseStream() {
        this.writeLog();
    }

    protected void onResetStream() {
        this.recordCount = 0L;
        this.batchCount = 0L;
    }

    private void writeLog() {
        this.vars.put(RECORD_COUNT_VAR, Long.toString(this.recordCount));
        this.vars.put(BATCH_COUNT_VAR, Long.toString(this.batchCount));
        this.vars.put(BATCH_SIZE_VAR, Long.toString(this.batchSize));
        this.vars.put(TOTAL_RECORD_COUNT_VAR, Long.toString(this.batchSize * this.batchCount + this.recordCount));
        LOG.info(StringUtil.format((String)this.format, this.vars));
    }
}

