/*
 * Decompiled with CFR 0.152.
 */
package org.metafacture.monitoring;

import org.metafacture.framework.FluxCommand;
import org.metafacture.framework.ObjectReceiver;
import org.metafacture.framework.annotations.Description;
import org.metafacture.framework.annotations.In;
import org.metafacture.framework.annotations.Out;
import org.metafacture.framework.helpers.DefaultObjectPipe;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Description(value="logs objects with the toString method")
@In(value=Object.class)
@Out(value=Object.class)
@FluxCommand(value="log-object")
public final class ObjectLogger<T>
extends DefaultObjectPipe<T, ObjectReceiver<T>> {
    private static final Logger LOG = LoggerFactory.getLogger(ObjectLogger.class);
    private final String logPrefix;

    public ObjectLogger() {
        this("");
    }

    public ObjectLogger(String logPrefix) {
        this.logPrefix = logPrefix;
    }

    public void process(T obj) {
        LOG.debug("{}{}", (Object)this.logPrefix, obj);
        if (this.getReceiver() != null) {
            ((ObjectReceiver)this.getReceiver()).process(obj);
        }
    }

    protected void onResetStream() {
        LOG.debug("{}resetStream", (Object)this.logPrefix);
    }

    protected void onCloseStream() {
        LOG.debug("{}closeStream", (Object)this.logPrefix);
    }
}

