/*
 * Decompiled with CFR 0.152.
 */
package org.metafacture.monitoring;

import java.util.HashMap;
import java.util.Map;
import org.metafacture.commons.StringUtil;
import org.metafacture.framework.FluxCommand;
import org.metafacture.framework.ObjectReceiver;
import org.metafacture.framework.annotations.Description;
import org.metafacture.framework.annotations.In;
import org.metafacture.framework.annotations.Out;
import org.metafacture.framework.helpers.DefaultObjectPipe;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Description(value="Writes log info for every BATCHSIZE records.")
@In(value=Object.class)
@Out(value=Object.class)
@FluxCommand(value="object-batch-log")
public final class ObjectBatchLogger<T>
extends DefaultObjectPipe<T, ObjectReceiver<T>> {
    public static final String RECORD_COUNT_VAR = "records";
    public static final String TOTAL_RECORD_COUNT_VAR = "totalRecords";
    public static final long DEFAULT_BATCH_SIZE = 1000L;
    public static final String BATCH_COUNT_VAR = "batches";
    public static final String BATCH_SIZE_VAR = "batchSize";
    public static final String DEFAULT_FORMAT = "records processed: ${totalRecords}";
    private static final Logger LOG = LoggerFactory.getLogger(ObjectBatchLogger.class);
    private final Map<String, String> vars = new HashMap<String, String>();
    private final String format;
    private long batchSize = 1000L;
    private long recordCount;
    private long batchCount;

    public ObjectBatchLogger() {
        this.format = DEFAULT_FORMAT;
    }

    public ObjectBatchLogger(String format) {
        this.format = format;
    }

    ObjectBatchLogger(String format, Map<String, String> vars) {
        this.format = format;
        this.vars.putAll(vars);
    }

    public void setBatchSize(int batchSize) {
        this.batchSize = batchSize;
    }

    private void writeLog() {
        this.vars.put(RECORD_COUNT_VAR, Long.toString(this.recordCount));
        this.vars.put(BATCH_COUNT_VAR, Long.toString(this.batchCount));
        this.vars.put(BATCH_SIZE_VAR, Long.toString(this.batchSize));
        this.vars.put(TOTAL_RECORD_COUNT_VAR, Long.toString(this.batchSize * this.batchCount + this.recordCount));
        LOG.info(StringUtil.format((String)this.format, this.vars));
    }

    protected void onCloseStream() {
        this.writeLog();
    }

    public void process(T obj) {
        if (this.getReceiver() != null) {
            ((ObjectReceiver)this.getReceiver()).process(obj);
        }
        ++this.recordCount;
        this.recordCount %= this.batchSize;
        if (0L == this.recordCount) {
            ++this.batchCount;
            this.writeLog();
        }
    }
}

