/*
 * Decompiled with CFR 0.152.
 */
package org.metafacture.javaintegration.pojo;

import java.beans.Introspector;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import org.metafacture.framework.MetafactureException;
import org.metafacture.javaintegration.pojo.ValueSetter;
import org.metafacture.javaintegration.pojo.ValueType;

class MethodValueSetter
implements ValueSetter {
    private static final String METHOD_PREFIX = "set";
    private final String name;
    private final Method method;

    MethodValueSetter(Method method) {
        assert (MethodValueSetter.supportsMethod(method));
        this.method = method;
        this.name = Introspector.decapitalize(method.getName().substring(METHOD_PREFIX.length()));
    }

    static boolean supportsMethod(Method m) {
        return Modifier.isPublic(m.getModifiers()) && m.getName().length() > METHOD_PREFIX.length() && m.getName().startsWith(METHOD_PREFIX) && m.getParameterTypes().length == 1;
    }

    @Override
    public void setValue(Object object, Object value) {
        try {
            this.method.invoke(object, value);
        }
        catch (IllegalArgumentException e) {
            throw new MetafactureException("The given object don't have a method named " + this.method.getName(), (Throwable)e);
        }
        catch (IllegalAccessException e) {
            throw new MetafactureException("Can't access the method named " + this.method.getName(), (Throwable)e);
        }
        catch (InvocationTargetException e) {
            throw new MetafactureException("Invoking the method named " + this.method.getName() + " throws an excpetion", (Throwable)e);
        }
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public ValueType getValueType() {
        return new ValueType(this.method.getParameterTypes()[0], this.method.getGenericParameterTypes()[0]);
    }
}

