/*
 * Decompiled with CFR 0.152.
 */
package org.metafacture.javaintegration.pojo;

import java.beans.Introspector;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import org.metafacture.framework.MetafactureException;
import org.metafacture.javaintegration.pojo.ValueGetter;

class MethodValueGetter
implements ValueGetter {
    private static final String METHOD_PREFIX = "get";
    private final Method method;
    private final String name;

    MethodValueGetter(Method method) {
        assert (MethodValueGetter.supportsMethod(method));
        this.method = method;
        this.name = Introspector.decapitalize(method.getName().substring(METHOD_PREFIX.length()));
    }

    static boolean supportsMethod(Method m) {
        return Modifier.isPublic(m.getModifiers()) && m.getName().length() > METHOD_PREFIX.length() && m.getName().startsWith(METHOD_PREFIX);
    }

    @Override
    public Object getValue(Object object) {
        try {
            return this.method.invoke(object, new Object[0]);
        }
        catch (IllegalArgumentException e) {
            throw new MetafactureException("The given object don't have a method named " + this.method.getName(), (Throwable)e);
        }
        catch (IllegalAccessException e) {
            throw new MetafactureException("Can't access the method named " + this.method.getName(), (Throwable)e);
        }
        catch (InvocationTargetException e) {
            throw new MetafactureException("Invoking the method named " + this.method.getName() + " throws an excpetion", (Throwable)e);
        }
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public Class<?> getValueType() {
        return this.method.getReturnType();
    }
}

