/*
 * Decompiled with CFR 0.152.
 */
package org.metafacture.javaintegration.pojo;

import java.util.Map;
import org.metafacture.framework.StreamReceiver;
import org.metafacture.javaintegration.pojo.TypeDecoder;
import org.metafacture.javaintegration.pojo.TypeDecoderFactory;

class MapTypeDecoder
implements TypeDecoder {
    private final TypeDecoderFactory typeDecoderFactory;

    MapTypeDecoder(TypeDecoderFactory typeDecoderFactory) {
        this.typeDecoderFactory = typeDecoderFactory;
    }

    static boolean supportsType(Class<?> clazz) {
        return Map.class.isAssignableFrom(clazz);
    }

    @Override
    public void decodeToStream(StreamReceiver streamReceiver, String name, Object object) {
        Map map = (Map)object;
        if (name != null) {
            streamReceiver.startEntity(name);
        }
        for (Map.Entry entry : map.entrySet()) {
            String key = entry.getKey().toString();
            Object value = entry.getValue();
            TypeDecoder typeDecoder = this.typeDecoderFactory.create(value.getClass());
            typeDecoder.decodeToStream(streamReceiver, key, value);
        }
        if (name != null) {
            streamReceiver.endEntity();
        }
    }
}

