/*
 * Decompiled with CFR 0.152.
 */
package org.metafacture.javaintegration;

import java.util.List;
import java.util.Map;
import org.metafacture.commons.types.ListMap;
import org.metafacture.framework.FluxCommand;
import org.metafacture.framework.StreamReceiver;
import org.metafacture.framework.annotations.In;
import org.metafacture.framework.annotations.Out;
import org.metafacture.framework.helpers.DefaultObjectPipe;

@In(value=ListMap.class)
@Out(value=StreamReceiver.class)
@FluxCommand(value="string-list-map-to-stream")
public final class StringListMapToStream
extends DefaultObjectPipe<ListMap<String, String>, StreamReceiver> {
    public void process(ListMap<String, String> listMap) {
        assert (!this.isClosed());
        StringListMapToStream.process(listMap, (StreamReceiver)this.getReceiver());
    }

    public static void process(ListMap<String, String> listMap, StreamReceiver receiver) {
        receiver.startRecord(listMap.getId());
        for (Map.Entry entry : listMap.entrySet()) {
            String name = (String)entry.getKey();
            for (String value : (List)entry.getValue()) {
                receiver.literal(name, value);
            }
        }
        receiver.endRecord();
    }
}

