/*
 * Decompiled with CFR 0.152.
 */
package org.metafacture.javaintegration.pojo;

import org.metafacture.framework.MetafactureException;
import org.metafacture.javaintegration.pojo.ComplexTypeEncoder;
import org.metafacture.javaintegration.pojo.ListTypeEncoder;
import org.metafacture.javaintegration.pojo.MapTypeEncoder;
import org.metafacture.javaintegration.pojo.TypeEncoder;
import org.metafacture.javaintegration.pojo.ValueType;

class TypeEncoderFactory {
    TypeEncoderFactory() {
    }

    TypeEncoder create(ValueType valueType) {
        TypeEncoder typeEncoder;
        Class<?> rawClass = valueType.getRawClass();
        if (MapTypeEncoder.supportsType(rawClass)) {
            typeEncoder = new MapTypeEncoder(valueType);
        } else if (ListTypeEncoder.supportsType(rawClass)) {
            typeEncoder = new ListTypeEncoder(valueType);
        } else if (ComplexTypeEncoder.supportsType(rawClass)) {
            typeEncoder = new ComplexTypeEncoder(rawClass);
        } else {
            throw new MetafactureException("Can't encode type " + rawClass);
        }
        return typeEncoder;
    }
}

