/*
 * Decompiled with CFR 0.152.
 */
package org.metafacture.javaintegration.pojo;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import org.metafacture.framework.MetafactureException;
import org.metafacture.javaintegration.pojo.ValueSetter;
import org.metafacture.javaintegration.pojo.ValueType;

class FieldValueSetter
implements ValueSetter {
    private final Field field;

    FieldValueSetter(Field field) {
        assert (FieldValueSetter.supportsField(field));
        this.field = field;
    }

    static boolean supportsField(Field f) {
        return Modifier.isPublic(f.getModifiers());
    }

    @Override
    public void setValue(Object object, Object value) {
        try {
            this.field.set(object, value);
        }
        catch (IllegalArgumentException e) {
            throw new MetafactureException("The given object don't have a field named " + this.field.getName(), (Throwable)e);
        }
        catch (IllegalAccessException e) {
            throw new MetafactureException("Can't access the field named " + this.field.getName(), (Throwable)e);
        }
    }

    @Override
    public String getName() {
        return this.field.getName();
    }

    @Override
    public ValueType getValueType() {
        return new ValueType(this.field.getType(), this.field.getGenericType());
    }
}

