/*
 * Decompiled with CFR 0.152.
 */
package org.metafacture.javaintegration.pojo;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import org.metafacture.framework.MetafactureException;
import org.metafacture.javaintegration.pojo.FieldValueSetter;
import org.metafacture.javaintegration.pojo.ListTypeEncoder;
import org.metafacture.javaintegration.pojo.MapTypeEncoder;
import org.metafacture.javaintegration.pojo.MethodValueSetter;
import org.metafacture.javaintegration.pojo.TypeEncoder;
import org.metafacture.javaintegration.pojo.ValueSetter;
import org.metafacture.javaintegration.pojo.ValueType;

class ComplexTypeEncoder
implements TypeEncoder {
    private final Object instance;
    private final Map<String, ValueSetter> valueSetters;

    ComplexTypeEncoder(Class<?> clazz) {
        assert (ComplexTypeEncoder.supportsType(clazz));
        this.instance = ComplexTypeEncoder.createInstance(clazz);
        this.valueSetters = new HashMap<String, ValueSetter>();
        this.addFieldValueSettersFor(clazz);
        this.addMethodValueSettersFor(clazz);
    }

    private static Object createInstance(Class<?> clazz) {
        try {
            return clazz.newInstance();
        }
        catch (Exception e) {
            throw new MetafactureException("Can't instantiate object of class: " + clazz, (Throwable)e);
        }
    }

    private void addFieldValueSettersFor(Class<?> clazz) {
        Field[] fields;
        for (Field field : fields = clazz.getDeclaredFields()) {
            if (!FieldValueSetter.supportsField(field)) continue;
            FieldValueSetter fieldValueSetter = new FieldValueSetter(field);
            this.valueSetters.put(fieldValueSetter.getName(), fieldValueSetter);
        }
    }

    private void addMethodValueSettersFor(Class<?> clazz) {
        Method[] methods;
        for (Method method : methods = clazz.getDeclaredMethods()) {
            if (!MethodValueSetter.supportsMethod(method)) continue;
            MethodValueSetter methodValueSetter = new MethodValueSetter(method);
            this.valueSetters.put(methodValueSetter.getName(), methodValueSetter);
        }
    }

    static boolean supportsType(Class<?> clazz) {
        return !clazz.isPrimitive() && !clazz.equals(String.class) && !MapTypeEncoder.supportsType(clazz) && !ListTypeEncoder.supportsType(clazz);
    }

    @Override
    public void setValue(String name, Object value) {
        ValueSetter valueSetter = this.valueSetters.get(name);
        valueSetter.setValue(this.instance, value);
    }

    @Override
    public ValueType getValueType(String name) {
        ValueSetter valueSetter = this.valueSetters.get(name);
        if (valueSetter == null) {
            throw new MetafactureException("There is no attribute with name " + name);
        }
        return valueSetter.getValueType();
    }

    @Override
    public Object getInstance() {
        return this.instance;
    }
}

