/*
 * Decompiled with CFR 0.152.
 */
package org.metafacture.javaintegration.pojo;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import org.metafacture.framework.StreamReceiver;
import org.metafacture.javaintegration.pojo.ArrayTypeDecoder;
import org.metafacture.javaintegration.pojo.CollectionTypeDecoder;
import org.metafacture.javaintegration.pojo.FieldValueGetter;
import org.metafacture.javaintegration.pojo.MapTypeDecoder;
import org.metafacture.javaintegration.pojo.MetafactureSourceTypeDecoder;
import org.metafacture.javaintegration.pojo.MethodValueGetter;
import org.metafacture.javaintegration.pojo.SimpleTypeDecoder;
import org.metafacture.javaintegration.pojo.TypeDecoder;
import org.metafacture.javaintegration.pojo.TypeDecoderFactory;
import org.metafacture.javaintegration.pojo.ValueGetter;

class ComplexTypeDecoder
implements TypeDecoder {
    private final TypeDecoderFactory typeDecoderFactory;
    private final List<ValueGetter> valueGetters;

    ComplexTypeDecoder(Class<?> clazz, TypeDecoderFactory typeDecoderFactory) {
        this.typeDecoderFactory = typeDecoderFactory;
        this.valueGetters = new ArrayList<ValueGetter>();
        this.addFieldValueGettersFor(clazz);
        this.addMethodValueGettersFor(clazz);
    }

    private void addFieldValueGettersFor(Class<?> clazz) {
        Field[] fields;
        for (Field field : fields = clazz.getDeclaredFields()) {
            if (!FieldValueGetter.supportsField(field)) continue;
            this.valueGetters.add(new FieldValueGetter(field));
        }
    }

    private void addMethodValueGettersFor(Class<?> clazz) {
        Method[] methods;
        for (Method method : methods = clazz.getDeclaredMethods()) {
            if (!MethodValueGetter.supportsMethod(method)) continue;
            this.valueGetters.add(new MethodValueGetter(method));
        }
    }

    static boolean supportsType(Class<?> clazz) {
        return !SimpleTypeDecoder.supportsType(clazz) && !MetafactureSourceTypeDecoder.supportsType(clazz) && !CollectionTypeDecoder.supportsType(clazz) && !ArrayTypeDecoder.supportsType(clazz) && !MapTypeDecoder.supportsType(clazz);
    }

    @Override
    public void decodeToStream(StreamReceiver streamReceiver, String name, Object object) {
        if (name != null) {
            streamReceiver.startEntity(name);
        }
        for (ValueGetter valueGetter : this.valueGetters) {
            Object value = valueGetter.getValue(object);
            Class<?> valueType = valueGetter.getValueType();
            String valueName = valueGetter.getName();
            TypeDecoder typeDecoder = this.typeDecoderFactory.create(valueType);
            typeDecoder.decodeToStream(streamReceiver, valueName, value);
        }
        if (name != null) {
            streamReceiver.endEntity();
        }
    }
}

