/*
 * Decompiled with CFR 0.152.
 */
package org.metafacture.javaintegration;

import java.util.LinkedList;
import java.util.Queue;
import org.metafacture.framework.ObjectReceiver;

public final class ObjectCollector<T>
implements ObjectReceiver<T> {
    private final Queue<T> buffer = new LinkedList<T>();
    private final int maxCapacity;
    private boolean closed;

    public ObjectCollector() {
        this(-1);
    }

    public ObjectCollector(int maxCapacity) {
        this.maxCapacity = maxCapacity;
    }

    public boolean isClosed() {
        return this.closed;
    }

    public void process(T obj) {
        if (this.closed) {
            throw new IllegalStateException("Module has been closed.");
        }
        if (this.buffer.size() == this.maxCapacity) {
            throw new IllegalStateException("Buffer reached max capacity.");
        }
        this.buffer.add(obj);
    }

    public void resetStream() {
        this.buffer.clear();
        this.closed = false;
    }

    public void closeStream() {
        this.closed = true;
    }

    public void clear() {
        this.buffer.clear();
    }

    public T pop() {
        return this.buffer.poll();
    }
}

