/*
 * Decompiled with CFR 0.152.
 */
package org.metafacture.io;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.SequenceInputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Pattern;
import org.metafacture.framework.FluxCommand;
import org.metafacture.framework.MetafactureException;
import org.metafacture.framework.ObjectReceiver;
import org.metafacture.framework.annotations.Description;
import org.metafacture.framework.annotations.In;
import org.metafacture.framework.annotations.Out;
import org.metafacture.framework.helpers.DefaultObjectPipe;

@Description(value="Opens an HTTP resource. Supports setting HTTP header fields `Accept`, `Accept-Charset` and `Content-Type`, as well as generic headers (separated by `\\n`). Defaults: request `method` = `GET`, request `url` = `@-` (input data), request `body` = `@-` (input data) if request method supports body and input data not already used, `Accept` header = `*/*`, `Accept-Charset` header (`encoding`) = `UTF-8`, `errorPrefix` = `ERROR: `.")
@In(value=String.class)
@Out(value=Reader.class)
@FluxCommand(value="open-http")
public final class HttpOpener
extends DefaultObjectPipe<String, ObjectReceiver<Reader>> {
    public static final String ACCEPT_DEFAULT = "*/*";
    public static final String ACCEPT_HEADER = "accept";
    public static final String CONTENT_TYPE_HEADER = "content-type";
    public static final String DEFAULT_PREFIX = "ERROR: ";
    public static final String ENCODING_DEFAULT = "UTF-8";
    public static final String ENCODING_HEADER = "accept-charset";
    public static final String INPUT_DESIGNATOR = "@-";
    public static final String DEFAULT_METHOD_NAME = "GET";
    public static final Method DEFAULT_METHOD = Method.valueOf("GET");
    public static final String HEADER_FIELD_SEPARATOR = "\n";
    public static final String HEADER_VALUE_SEPARATOR = ":";
    private static final Pattern HEADER_FIELD_SEPARATOR_PATTERN = Pattern.compile("\n");
    private static final Pattern HEADER_VALUE_SEPARATOR_PATTERN = Pattern.compile(":");
    private final Map<String, String> headers = new HashMap<String, String>();
    private Method method;
    private String body;
    private String errorPrefix;
    private String url;
    private boolean inputUsed;

    public HttpOpener() {
        this.setAccept(ACCEPT_DEFAULT);
        this.setEncoding(ENCODING_DEFAULT);
        this.setErrorPrefix(DEFAULT_PREFIX);
        this.setMethod(DEFAULT_METHOD);
        this.setUrl(INPUT_DESIGNATOR);
    }

    public void setAccept(String accept) {
        this.setHeader(ACCEPT_HEADER, accept);
    }

    public void setBody(String body) {
        this.body = body;
    }

    public void setContentType(String contentType) {
        this.setHeader(CONTENT_TYPE_HEADER, contentType);
    }

    public void setEncoding(String encoding) {
        this.setHeader(ENCODING_HEADER, encoding);
    }

    public void setErrorPrefix(String errorPrefix) {
        this.errorPrefix = errorPrefix;
    }

    public void setHeader(String header) {
        Arrays.stream(HEADER_FIELD_SEPARATOR_PATTERN.split(header)).forEach(h -> {
            String[] parts = HEADER_VALUE_SEPARATOR_PATTERN.split((CharSequence)h, 2);
            if (parts.length != 2) {
                throw new IllegalArgumentException("Invalid header: " + h);
            }
            this.setHeader(parts[0], parts[1].trim());
        });
    }

    public void setHeader(String key, String value) {
        this.headers.put(key.toLowerCase(), value);
    }

    public void setMethod(Method method) {
        this.method = method;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public void process(String input) {
        try {
            String requestUrl = this.getInput(input, this.url);
            String requestBody = this.getInput(input, this.body == null && this.method.getRequestHasBody() ? INPUT_DESIGNATOR : this.body);
            HttpURLConnection connection = (HttpURLConnection)new URL(requestUrl).openConnection();
            connection.setRequestMethod(this.method.name());
            this.headers.forEach(connection::addRequestProperty);
            if (requestBody != null) {
                connection.setDoOutput(true);
                connection.getOutputStream().write(requestBody.getBytes());
            }
            InputStream inputStream = this.getInputStream(connection);
            String contentEncoding = this.getEncoding(connection.getContentEncoding());
            ((ObjectReceiver)this.getReceiver()).process((Object)new InputStreamReader(inputStream, contentEncoding));
        }
        catch (IOException e) {
            throw new MetafactureException((Throwable)e);
        }
    }

    private String getInput(String input, String value) {
        String result;
        if (!INPUT_DESIGNATOR.equals(value)) {
            result = value;
        } else if (this.inputUsed) {
            result = null;
        } else {
            this.inputUsed = true;
            result = input;
        }
        return result;
    }

    private InputStream getInputStream(HttpURLConnection connection) throws IOException {
        try {
            return connection.getInputStream();
        }
        catch (IOException e) {
            InputStream errorStream = connection.getErrorStream();
            if (errorStream != null) {
                return this.getErrorStream(errorStream);
            }
            throw e;
        }
    }

    private InputStream getErrorStream(InputStream errorStream) {
        if (this.errorPrefix != null) {
            ByteArrayInputStream errorPrefixStream = new ByteArrayInputStream(this.errorPrefix.getBytes());
            return new SequenceInputStream(errorPrefixStream, errorStream);
        }
        return errorStream;
    }

    private String getEncoding(String contentEncoding) {
        return contentEncoding != null ? contentEncoding : this.headers.get(ENCODING_HEADER);
    }

    public static enum Method {
        DELETE(false, true),
        GET(false, true),
        HEAD(false, false),
        OPTIONS(false, true),
        POST(true, true),
        PUT(true, true),
        TRACE(false, true);

        private final boolean requestHasBody;
        private final boolean responseHasBody;

        private Method(boolean requestHasBody, boolean responseHasBody) {
            this.requestHasBody = requestHasBody;
            this.responseHasBody = responseHasBody;
        }

        public boolean getRequestHasBody() {
            return this.requestHasBody;
        }

        public boolean getResponseHasBody() {
            return this.responseHasBody;
        }
    }
}

