/*
 * Decompiled with CFR 0.152.
 */
package org.metafacture.io;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import org.apache.commons.io.input.BOMInputStream;
import org.metafacture.framework.FluxCommand;
import org.metafacture.framework.MetafactureException;
import org.metafacture.framework.ObjectReceiver;
import org.metafacture.framework.annotations.Description;
import org.metafacture.framework.annotations.In;
import org.metafacture.framework.annotations.Out;
import org.metafacture.framework.helpers.DefaultObjectPipe;
import org.metafacture.io.FileCompression;

@Description(value="Opens a file.")
@In(value=String.class)
@Out(value=Reader.class)
@FluxCommand(value="open-file")
public final class FileOpener
extends DefaultObjectPipe<String, ObjectReceiver<Reader>> {
    private String encoding = "UTF-8";
    private FileCompression compression = FileCompression.AUTO;
    private boolean decompressConcatenated = false;

    public String getEncoding() {
        return this.encoding;
    }

    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    public FileCompression getCompression() {
        return this.compression;
    }

    public void setCompression(FileCompression compression) {
        this.compression = compression;
    }

    public void setCompression(String compression) {
        this.setCompression(FileCompression.valueOf(compression.toUpperCase()));
    }

    public boolean getDecompressConcatenated() {
        return this.decompressConcatenated;
    }

    public void setDecompressConcatenated(boolean decompressConcatenated) {
        this.decompressConcatenated = decompressConcatenated;
    }

    public Reader open(String file) throws IOException {
        return this.open(new FileInputStream(file));
    }

    public Reader open(InputStream stream) throws IOException {
        try {
            InputStream decompressor = this.compression.createDecompressor(stream, this.decompressConcatenated);
            try {
                return new InputStreamReader((InputStream)new BOMInputStream(decompressor), this.encoding);
            }
            catch (IOException | MetafactureException e) {
                decompressor.close();
                throw e;
            }
        }
        catch (IOException | MetafactureException e) {
            stream.close();
            throw e;
        }
    }

    public void process(String file) {
        try {
            ((ObjectReceiver)this.getReceiver()).process((Object)this.open(file));
        }
        catch (IOException e) {
            throw new MetafactureException((Throwable)e);
        }
    }
}

