/*
 * Decompiled with CFR 0.152.
 */
package org.metafacture.io;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.commons.compress.compressors.CompressorException;
import org.apache.commons.compress.compressors.CompressorStreamFactory;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.input.ProxyInputStream;
import org.apache.commons.io.output.ProxyOutputStream;
import org.metafacture.framework.MetafactureException;

public enum FileCompression {
    NONE{

        @Override
        public OutputStream createCompressor(OutputStream writeTo, String fileName) {
            return new ProxyOutputStream(writeTo);
        }

        @Override
        public InputStream createDecompressor(InputStream readFrom, boolean decompressConcatenated) {
            return new ProxyInputStream(readFrom){};
        }
    }
    ,
    AUTO{

        @Override
        public OutputStream createCompressor(OutputStream writeTo, String fileName) {
            if (fileName == null) {
                throw new IllegalArgumentException("fileName is required for auto-selecting compressor");
            }
            String extension = FilenameUtils.getExtension((String)fileName);
            FileCompression compressor = "gz".equalsIgnoreCase(extension) ? GZIP : ("gzip".equalsIgnoreCase(extension) ? GZIP : ("bz2".equalsIgnoreCase(extension) ? BZIP2 : ("bzip2".equalsIgnoreCase(extension) ? BZIP2 : ("xz".equalsIgnoreCase(extension) ? XZ : NONE))));
            return compressor.createCompressor(writeTo, fileName);
        }

        @Override
        public InputStream createDecompressor(InputStream readFrom, boolean decompressConcatenated) {
            InputStream bufferedStream = FileCompression.bufferStream(readFrom);
            try {
                return decompressConcatenated ? APACHE_COMPRESSOR_FACTORY_DECOMPRESS_CONCATENATED.createCompressorInputStream(bufferedStream) : APACHE_COMPRESSOR_FACTORY_NO_DECOMPRESS_CONCATENATED.createCompressorInputStream(bufferedStream);
            }
            catch (CompressorException e) {
                return NONE.createDecompressor(bufferedStream, decompressConcatenated);
            }
        }
    }
    ,
    BZIP2{

        @Override
        public OutputStream createCompressor(OutputStream writeTo, String fileName) {
            try {
                return APACHE_COMPRESSOR_FACTORY.createCompressorOutputStream("bzip2", FileCompression.bufferStream(writeTo));
            }
            catch (CompressorException e) {
                throw new MetafactureException((Throwable)e);
            }
        }

        @Override
        public InputStream createDecompressor(InputStream readFrom, boolean decompressConcatenated) {
            try {
                return APACHE_COMPRESSOR_FACTORY.createCompressorInputStream("bzip2", FileCompression.bufferStream(readFrom), decompressConcatenated);
            }
            catch (CompressorException e) {
                throw new MetafactureException((Throwable)e);
            }
        }
    }
    ,
    GZIP{

        @Override
        public OutputStream createCompressor(OutputStream writeTo, String fileName) {
            try {
                return APACHE_COMPRESSOR_FACTORY.createCompressorOutputStream("gz", FileCompression.bufferStream(writeTo));
            }
            catch (CompressorException e) {
                throw new MetafactureException((Throwable)e);
            }
        }

        @Override
        public InputStream createDecompressor(InputStream readFrom, boolean decompressConcatenated) {
            try {
                return APACHE_COMPRESSOR_FACTORY.createCompressorInputStream("gz", FileCompression.bufferStream(readFrom), decompressConcatenated);
            }
            catch (CompressorException e) {
                throw new MetafactureException((Throwable)e);
            }
        }
    }
    ,
    PACK200{

        @Override
        public OutputStream createCompressor(OutputStream writeTo, String fileName) {
            try {
                return APACHE_COMPRESSOR_FACTORY.createCompressorOutputStream("pack200", FileCompression.bufferStream(writeTo));
            }
            catch (CompressorException e) {
                throw new MetafactureException((Throwable)e);
            }
        }

        @Override
        public InputStream createDecompressor(InputStream readFrom, boolean decompressConcatenated) {
            try {
                return APACHE_COMPRESSOR_FACTORY.createCompressorInputStream("pack200", FileCompression.bufferStream(readFrom), decompressConcatenated);
            }
            catch (CompressorException e) {
                throw new MetafactureException((Throwable)e);
            }
        }
    }
    ,
    XZ{

        @Override
        public OutputStream createCompressor(OutputStream writeTo, String fileName) {
            try {
                return APACHE_COMPRESSOR_FACTORY.createCompressorOutputStream("xz", FileCompression.bufferStream(writeTo));
            }
            catch (CompressorException e) {
                throw new MetafactureException((Throwable)e);
            }
        }

        @Override
        public InputStream createDecompressor(InputStream readFrom, boolean decompressConcatenated) {
            try {
                return APACHE_COMPRESSOR_FACTORY.createCompressorInputStream("xz", FileCompression.bufferStream(readFrom), decompressConcatenated);
            }
            catch (CompressorException e) {
                throw new MetafactureException((Throwable)e);
            }
        }
    };

    public static final boolean DEFAULT_DECOMPRESS_CONCATENATED = false;
    private static final CompressorStreamFactory APACHE_COMPRESSOR_FACTORY_DECOMPRESS_CONCATENATED;
    private static final CompressorStreamFactory APACHE_COMPRESSOR_FACTORY_NO_DECOMPRESS_CONCATENATED;
    private static final CompressorStreamFactory APACHE_COMPRESSOR_FACTORY;
    private static final int BUFFER_SIZE = 0x800000;

    public abstract OutputStream createCompressor(OutputStream var1, String var2);

    public abstract InputStream createDecompressor(InputStream var1, boolean var2);

    public InputStream createDecompressor(InputStream readFrom) {
        return this.createDecompressor(readFrom, false);
    }

    private static OutputStream bufferStream(OutputStream stream) {
        if (stream instanceof BufferedOutputStream) {
            return stream;
        }
        return new BufferedOutputStream(stream, 0x800000);
    }

    private static InputStream bufferStream(InputStream stream) {
        if (stream instanceof BufferedInputStream) {
            return stream;
        }
        return new BufferedInputStream(stream, 0x800000);
    }

    static {
        APACHE_COMPRESSOR_FACTORY_DECOMPRESS_CONCATENATED = new CompressorStreamFactory(true);
        APACHE_COMPRESSOR_FACTORY = APACHE_COMPRESSOR_FACTORY_NO_DECOMPRESS_CONCATENATED = new CompressorStreamFactory(false);
    }
}

