/*
 * Decompiled with CFR 0.152.
 */
package org.metafacture.io;

import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import java.net.URLConnection;
import org.metafacture.framework.FluxCommand;
import org.metafacture.framework.MetafactureException;
import org.metafacture.framework.ObjectReceiver;
import org.metafacture.framework.annotations.Description;
import org.metafacture.framework.annotations.In;
import org.metafacture.framework.annotations.Out;
import org.metafacture.framework.helpers.DefaultObjectPipe;

@Description(value="Opens a http resource. Supports the setting of Accept and Accept-Charset as http header fields.")
@In(value=String.class)
@Out(value=Reader.class)
@FluxCommand(value="open-http")
public final class HttpOpener
extends DefaultObjectPipe<String, ObjectReceiver<Reader>> {
    private String encoding = "UTF-8";
    private String accept = "*/*";

    public void setAccept(String accept) {
        this.accept = accept;
    }

    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    public void process(String urlStr) {
        try {
            URL url = new URL(urlStr);
            URLConnection con = url.openConnection();
            con.addRequestProperty("Accept", this.accept);
            con.addRequestProperty("Accept-Charset", this.encoding);
            String enc = con.getContentEncoding();
            if (enc == null) {
                enc = this.encoding;
            }
            ((ObjectReceiver)this.getReceiver()).process((Object)new InputStreamReader(con.getInputStream(), enc));
        }
        catch (IOException e) {
            throw new MetafactureException((Throwable)e);
        }
    }
}

