/*
 * Decompiled with CFR 0.152.
 */
package org.metafacture.io;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Objects;
import java.util.function.Supplier;
import org.metafacture.framework.helpers.DefaultObjectReceiver;
import org.metafacture.io.CloseFailed;
import org.metafacture.io.OpenFailed;
import org.metafacture.io.WriteFailed;

public class ByteStreamFileWriter
extends DefaultObjectReceiver<byte[]> {
    private Supplier<File> fileNameSupplier;
    private boolean appendIfFileExists;
    private boolean flushAfterWrite;
    private OutputStream outputStream;

    public void setFileNameSupplier(Supplier<File> fileNameSupplier) {
        this.fileNameSupplier = Objects.requireNonNull(fileNameSupplier);
    }

    public void setAppendIfFileExists(boolean appendIfFileExists) {
        this.appendIfFileExists = appendIfFileExists;
    }

    public void setFlushAfterWrite(boolean flushAfterWrite) {
        this.flushAfterWrite = flushAfterWrite;
    }

    public void process(byte[] bytes) {
        this.ensureOpenStream();
        try {
            this.outputStream.write(bytes);
            if (this.flushAfterWrite) {
                this.outputStream.flush();
            }
        }
        catch (IOException e) {
            throw new WriteFailed("Error while writing bytes to output stream", e);
        }
    }

    public void resetStream() {
        this.closeStream();
        this.ensureOpenStream();
    }

    public void closeStream() {
        if (this.outputStream != null) {
            try {
                this.outputStream.close();
            }
            catch (IOException e) {
                throw new CloseFailed("Error while closing output stream", e);
            }
            this.outputStream = null;
        }
    }

    private void ensureOpenStream() {
        if (this.outputStream != null) {
            return;
        }
        try {
            this.outputStream = new FileOutputStream(this.fileNameSupplier.get(), this.appendIfFileExists);
        }
        catch (FileNotFoundException e) {
            throw new OpenFailed("Cannot open output stream. File not found.", e);
        }
    }
}

