/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.util.cc;

import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import org.junit.jupiter.api.Assumptions;
import org.junit.jupiter.api.extension.AfterAllCallback;
import org.junit.jupiter.api.extension.AfterEachCallback;
import org.junit.jupiter.api.extension.BeforeAllCallback;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.neo4j.driver.AuthToken;
import org.neo4j.driver.AuthTokens;
import org.neo4j.driver.util.Neo4jRunner;
import org.neo4j.driver.util.cc.Cluster;
import org.neo4j.driver.util.cc.CommandLineUtil;
import org.neo4j.driver.util.cc.SharedCluster;

public class ClusterExtension
implements BeforeAllCallback,
AfterEachCallback,
AfterAllCallback {
    private static final Path CLUSTER_DIR = Paths.get(Neo4jRunner.TARGET_DIR, "test-cluster").toAbsolutePath();
    private static final int INITIAL_PORT = 20000;
    public static final int CORE_COUNT = 3;
    public static final int READ_REPLICA_COUNT = 2;

    public Cluster getCluster() {
        return SharedCluster.get();
    }

    public AuthToken getDefaultAuthToken() {
        return AuthTokens.basic((String)"neo4j", (String)"password");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void beforeAll(ExtensionContext context) throws Exception {
        Assumptions.assumeTrue((boolean)CommandLineUtil.boltKitAvailable(), (String)"BoltKit cluster support unavailable");
        ClusterExtension.stopSingleInstanceDatabase();
        if (!SharedCluster.exists()) {
            SharedCluster.install(ClusterExtension.parseNeo4jVersion(), 3, 2, "password", 20000, CLUSTER_DIR);
            try {
                SharedCluster.start();
            }
            catch (Throwable startError) {
                try {
                    SharedCluster.kill();
                }
                catch (Throwable killError) {
                    startError.addSuppressed(killError);
                }
                finally {
                    SharedCluster.remove();
                }
                throw startError;
            }
            finally {
                ClusterExtension.addShutdownHookToStopCluster();
            }
        }
        this.getCluster().deleteData();
    }

    public void afterEach(ExtensionContext context) {
        Cluster cluster = this.getCluster();
        cluster.deleteData();
    }

    public void afterAll(ExtensionContext context) {
        if (SharedCluster.exists()) {
            try {
                SharedCluster.stop();
            }
            finally {
                SharedCluster.remove();
            }
        }
    }

    private static String parseNeo4jVersion() {
        String[] split = Neo4jRunner.NEOCTRL_ARGS.split("\\s+");
        return split[split.length - 1];
    }

    private static void stopSingleInstanceDatabase() throws IOException {
        if (Neo4jRunner.globalRunnerExists()) {
            Neo4jRunner.getOrCreateGlobalRunner().stopNeo4j();
        }
    }

    private static void addShutdownHookToStopCluster() {
        Runtime.getRuntime().addShutdownHook(new Thread(() -> {
            try {
                if (SharedCluster.exists()) {
                    SharedCluster.kill();
                }
            }
            catch (Throwable t) {
                System.err.println("Cluster stopping shutdown hook failed");
                t.printStackTrace();
            }
        }));
    }
}

